/*
 * Decompiled with CFR 0.152.
 */
package org.debian.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import org.debian.security.InvalidKeystorePasswordException;
import org.debian.security.KeyStoreHandler;
import org.debian.security.UnableToSaveKeystoreException;
import org.debian.security.UnknownInputException;

public class UpdateCertificates {
    private KeyStoreHandler keystore;

    public static void main(String[] args) throws IOException, GeneralSecurityException {
        String passwordString = "changeit";
        if (args.length == 2 && args[0].equals("-storepass")) {
            passwordString = args[1];
        } else if (args.length > 0) {
            System.err.println("Usage: java org.debian.security.UpdateCertificates [-storepass <password>]");
            System.exit(1);
        }
        try {
            UpdateCertificates uc = new UpdateCertificates("/etc/ssl/certs/java/cacerts", passwordString);
            uc.processChanges(new InputStreamReader(System.in, "UTF8"));
            uc.finish();
        }
        catch (InvalidKeystorePasswordException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (UnableToSaveKeystoreException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public UpdateCertificates(String keystoreFile, String password) throws IOException, GeneralSecurityException, InvalidKeystorePasswordException {
        this.keystore = new KeyStoreHandler(keystoreFile, password.toCharArray());
    }

    protected void processChanges(Reader reader) throws IOException, GeneralSecurityException {
        String line;
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            try {
                this.parseLine(line);
            }
            catch (UnknownInputException e) {
                System.err.println("Unknown input: " + line);
            }
        }
    }

    protected void parseLine(String line) throws GeneralSecurityException, IOException, UnknownInputException {
        if (line.isEmpty()) {
            return;
        }
        String path = line.substring(1);
        String filename = path.substring(path.lastIndexOf("/") + 1);
        String alias = "debian:" + filename;
        if (line.startsWith("+")) {
            this.keystore.addAlias(alias, path);
        } else if (line.startsWith("-")) {
            this.keystore.deleteAlias(alias);
        } else {
            throw new UnknownInputException(line);
        }
    }

    protected void finish() throws GeneralSecurityException, UnableToSaveKeystoreException {
        this.keystore.save();
    }
}

