/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import org.apache.fop.pdf.PDFImage;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.pdf.AbstractPDFImageHandler;
import org.apache.fop.render.pdf.ImageRawPNGAdapter;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageRawPNG;

public class PDFImageHandlerRawPNG
extends AbstractPDFImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_PNG};

    @Override
    PDFImage createPDFImage(Image image, String xobjectKey) {
        return new ImageRawPNGAdapter((ImageRawPNG)image, xobjectKey);
    }

    public int getPriority() {
        return 100;
    }

    public Class<ImageRawPNG> getSupportedImageClass() {
        return ImageRawPNG.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext targetContext, Image image) {
        return (image == null || image instanceof ImageRawPNG) && targetContext instanceof PDFRenderingContext;
    }
}

