/*
 * Decompiled with CFR 0.152.
 */
package dom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMAddLines
extends DOMParser {
    private PrintWriter out;
    private static boolean NotIncludeIgnorableWhiteSpaces = false;
    private XMLLocator locator;

    public DOMAddLines(String string) {
        try {
            this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.parse(string);
            this.out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8"));
        }
        catch (IOException iOException) {
            System.err.println("except" + iOException);
        }
        catch (SAXException sAXException) {
            System.err.println("except" + sAXException);
        }
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        String string = (String)node.getUserData("startLine");
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.out.println(string + ":<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                this.out.print(string + ":" + '<');
                this.out.print(node.getNodeName());
                Attr[] attrArray = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrArray.length; ++i) {
                    Attr attr = attrArray[i];
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(attr.getNodeValue());
                    this.out.print('\"');
                }
                this.out.print('>');
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    this.print(nodeList.item(i));
                }
                break;
            }
            case 5: {
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(node.getNodeValue());
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String string2 = node.getNodeValue();
                if (string2 != null && string2.length() > 0) {
                    this.out.print(' ');
                    this.out.print(string2);
                }
                this.out.print("?>");
                break;
            }
        }
        if (s == 1) {
            this.out.print("</");
            this.out.print(node.getNodeName());
            this.out.print('>');
        }
        this.out.flush();
    }

    private Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n;
        int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n2];
        for (n = 0; n < n2; ++n) {
            attrArray[n] = (Attr)namedNodeMap.item(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            String string = attrArray[n].getNodeName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = attrArray[i].getNodeName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        super.startElement(qName, xMLAttributes, augmentations);
        Node node = null;
        try {
            node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
        }
        catch (SAXException sAXException) {
            System.err.println("except" + sAXException);
        }
        if (node != null) {
            node.setUserData("startLine", String.valueOf(this.locator.getLineNumber()), null);
        }
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        super.startDocument(xMLLocator, string, namespaceContext, augmentations);
        this.locator = xMLLocator;
        Node node = null;
        try {
            node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
        }
        catch (SAXException sAXException) {
            System.err.println("except" + sAXException);
        }
        if (node != null) {
            node.setUserData("startLine", String.valueOf(xMLLocator.getLineNumber()), null);
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!NotIncludeIgnorableWhiteSpaces) {
            super.ignorableWhitespace(xMLString, augmentations);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            DOMAddLines.printUsage();
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-")) {
                if (string.equals("-h")) {
                    DOMAddLines.printUsage();
                    System.exit(1);
                }
                if (string.equals("-i")) {
                    NotIncludeIgnorableWhiteSpaces = true;
                    continue;
                }
            }
            DOMAddLines dOMAddLines = new DOMAddLines(string);
            Document document = dOMAddLines.getDocument();
            dOMAddLines.print(document);
        }
    }

    private static void printUsage() {
        System.err.println("usage: jre dom.DOMAddLines (options) uri ...");
        System.err.println();
        System.err.println("  -h       Display help screen.");
        System.err.println("  -i       Don't print ignorable white spaces.");
    }
}

