/*
 * Decompiled with CFR 0.152.
 */
package socket.io;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class WrappedInputStream
extends FilterInputStream {
    protected int fPacketCount;
    protected DataInputStream fDataInputStream;
    protected boolean fClosed;

    public WrappedInputStream(InputStream inputStream) {
        super(inputStream);
        this.fDataInputStream = new DataInputStream(inputStream);
    }

    @Override
    public int read() throws IOException {
        if (this.fClosed) {
            return -1;
        }
        if (this.fPacketCount == 0) {
            this.fPacketCount = this.fDataInputStream.readInt() & Integer.MAX_VALUE;
            if (this.fPacketCount == 0) {
                this.fClosed = true;
                return -1;
            }
        }
        --this.fPacketCount;
        return this.in.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.fClosed) {
            return -1;
        }
        if (this.fPacketCount == 0) {
            this.fPacketCount = this.fDataInputStream.readInt() & Integer.MAX_VALUE;
            if (this.fPacketCount == 0) {
                this.fClosed = true;
                return -1;
            }
        }
        if (n2 > this.fPacketCount) {
            n2 = this.fPacketCount;
        }
        if ((n3 = this.in.read(byArray, n, n2)) == -1) {
            this.fClosed = true;
            return -1;
        }
        this.fPacketCount -= n3;
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        if (!this.fClosed) {
            for (long i = 0L; i < l; ++i) {
                int n = this.read();
                if (n != -1) continue;
                return i + 1L;
            }
            return l;
        }
        return 0L;
    }

    @Override
    public void close() throws IOException {
        if (!this.fClosed) {
            this.fClosed = true;
            do {
                this.in.skip(this.fPacketCount);
                this.fPacketCount = this.fDataInputStream.readInt() & Integer.MAX_VALUE;
            } while (this.fPacketCount > 0);
        }
    }
}

