/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.autotable.flow;

import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.ReportDataRow;
import org.jfree.report.flow.FlowControlOperation;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.ElementLayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerFactory;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.modules.misc.autotable.AutoTableElement;

public class AutoTableLayoutController
extends ElementLayoutController {
    public static final int HANDLING_HEADER = 0;
    public static final int HANDLING_DATA = 1;
    public static final int HANDLING_FOOTER = 2;
    private int currentColumn;
    private int processingState;
    private int columnCount;

    @Override
    public void initialize(Object object, FlowController flowController, LayoutController layoutController) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        super.initialize(object, flowController, layoutController);
        ReportDataRow reportDataRow = flowController.getMasterRow().getReportDataRow();
        this.columnCount = reportDataRow.getColumnCount();
    }

    @Override
    protected LayoutController processContent(ReportTarget reportTarget) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        switch (this.processingState) {
            case 0: {
                return this.processHeader(reportTarget);
            }
            case 2: {
                return this.processFooter(reportTarget);
            }
            case 1: {
                return this.processData(reportTarget);
            }
        }
        throw new ReportProcessingException("No such state.");
    }

    private LayoutController processData(ReportTarget reportTarget) throws ReportProcessingException, DataSourceException, ReportDataFactoryException {
        Object object;
        AutoTableElement autoTableElement = (AutoTableElement)this.getElement();
        if (autoTableElement.getContentCount() == 0) {
            throw new ReportProcessingException("An Auto-Table must have at least one defined column.");
        }
        if (this.currentColumn == 0) {
            object = LayoutControllerUtil.createEmptyMap("http://jfreereport.sourceforge.net/namespaces/reports/flow/extension/autotable", "data-row");
            reportTarget.startElement((AttributeMap)object);
        }
        if (this.currentColumn < this.columnCount) {
            object = this.getFlowController();
            ReportContext reportContext = object.getReportContext();
            LayoutControllerFactory layoutControllerFactory = reportContext.getLayoutControllerFactory();
            int n = this.currentColumn % autoTableElement.getContentCount();
            AutoTableLayoutController autoTableLayoutController = (AutoTableLayoutController)this.clone();
            return layoutControllerFactory.create((FlowController)object, autoTableElement.getContentCell(n), autoTableLayoutController);
        }
        object = LayoutControllerUtil.createEmptyMap("http://jfreereport.sourceforge.net/namespaces/reports/flow/extension/autotable", "data-row");
        reportTarget.endElement((AttributeMap)object);
        FlowController flowController = this.getFlowController().performOperation(FlowControlOperation.ADVANCE);
        FlowController flowController2 = this.tryRepeatingCommit(flowController);
        if (flowController2 != null) {
            AutoTableLayoutController autoTableLayoutController = (AutoTableLayoutController)this.clone();
            autoTableLayoutController.setFlowController(flowController2);
            autoTableLayoutController.currentColumn = 0;
            return autoTableLayoutController;
        }
        AutoTableLayoutController autoTableLayoutController = (AutoTableLayoutController)this.clone();
        autoTableLayoutController.currentColumn = 0;
        autoTableLayoutController.processingState = 2;
        return autoTableLayoutController;
    }

    private LayoutController processFooter(ReportTarget reportTarget) throws ReportProcessingException, DataSourceException, ReportDataFactoryException {
        Object object;
        AutoTableElement autoTableElement = (AutoTableElement)this.getElement();
        if (autoTableElement.getFooterCount() == 0) {
            AutoTableLayoutController autoTableLayoutController = (AutoTableLayoutController)this.clone();
            autoTableLayoutController.currentColumn = 0;
            autoTableLayoutController.processingState = -1;
            autoTableLayoutController.setProcessingState(3);
            return autoTableLayoutController;
        }
        if (this.currentColumn == 0) {
            object = LayoutControllerUtil.createEmptyMap("http://jfreereport.sourceforge.net/namespaces/reports/flow/extension/autotable", "footer-row");
            reportTarget.startElement((AttributeMap)object);
        }
        if (this.currentColumn < this.columnCount) {
            object = this.getFlowController();
            ReportContext reportContext = object.getReportContext();
            LayoutControllerFactory layoutControllerFactory = reportContext.getLayoutControllerFactory();
            int n = this.currentColumn % autoTableElement.getFooterCount();
            AutoTableLayoutController autoTableLayoutController = (AutoTableLayoutController)this.clone();
            return layoutControllerFactory.create((FlowController)object, autoTableElement.getFooterCell(n), autoTableLayoutController);
        }
        object = LayoutControllerUtil.createEmptyMap("http://jfreereport.sourceforge.net/namespaces/reports/flow/extension/autotable", "footer-row");
        reportTarget.endElement((AttributeMap)object);
        AutoTableLayoutController autoTableLayoutController = (AutoTableLayoutController)this.clone();
        autoTableLayoutController.currentColumn = 0;
        autoTableLayoutController.processingState = -1;
        autoTableLayoutController.setProcessingState(3);
        return autoTableLayoutController;
    }

    private LayoutController processHeader(ReportTarget reportTarget) throws ReportProcessingException, DataSourceException, ReportDataFactoryException {
        Object object;
        AutoTableElement autoTableElement = (AutoTableElement)this.getElement();
        if (autoTableElement.getHeaderCount() == 0) {
            AutoTableLayoutController autoTableLayoutController = (AutoTableLayoutController)this.clone();
            autoTableLayoutController.currentColumn = 0;
            autoTableLayoutController.processingState = 1;
            return autoTableLayoutController;
        }
        if (this.currentColumn == 0) {
            object = LayoutControllerUtil.createEmptyMap("http://jfreereport.sourceforge.net/namespaces/reports/flow/extension/autotable", "header-row");
            reportTarget.startElement((AttributeMap)object);
        }
        if (this.currentColumn < this.columnCount) {
            object = this.getFlowController();
            ReportContext reportContext = object.getReportContext();
            LayoutControllerFactory layoutControllerFactory = reportContext.getLayoutControllerFactory();
            int n = this.currentColumn % autoTableElement.getHeaderCount();
            AutoTableLayoutController autoTableLayoutController = (AutoTableLayoutController)this.clone();
            return layoutControllerFactory.create((FlowController)object, autoTableElement.getHeaderCell(n), autoTableLayoutController);
        }
        object = LayoutControllerUtil.createEmptyMap("http://jfreereport.sourceforge.net/namespaces/reports/flow/extension/autotable", "header-row");
        reportTarget.endElement((AttributeMap)object);
        AutoTableLayoutController autoTableLayoutController = (AutoTableLayoutController)this.clone();
        autoTableLayoutController.currentColumn = 0;
        autoTableLayoutController.processingState = 1;
        return autoTableLayoutController;
    }

    @Override
    public LayoutController join(FlowController flowController) {
        AutoTableLayoutController autoTableLayoutController = (AutoTableLayoutController)this.clone();
        autoTableLayoutController.setFlowController(flowController);
        ++autoTableLayoutController.currentColumn;
        return autoTableLayoutController;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }
}

