/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.values;

import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSValue;

public class CSSNumericValue
implements CSSValue {
    public static final CSSNumericValue ZERO_LENGTH = CSSNumericValue.createValue(CSSNumericType.PT, 0.0);
    private double value;
    private CSSNumericType type;

    protected CSSNumericValue(CSSNumericType cSSNumericType, double d) {
        if (cSSNumericType == null) {
            throw new NullPointerException();
        }
        this.type = cSSNumericType;
        this.value = d;
    }

    public double getValue() {
        return this.value;
    }

    public CSSNumericType getType() {
        return this.type;
    }

    @Override
    public String getCSSText() {
        String string = this.type.getType();
        double d = this.getValue();
        if (string.length() == 0) {
            if (Math.floor(d) == d) {
                return String.valueOf((long)d);
            }
            return String.valueOf(d);
        }
        if (Math.floor(d) == d) {
            return (long)d + " " + string;
        }
        return d + " " + string;
    }

    public String toString() {
        return this.getCSSText();
    }

    public static CSSNumericValue createPtValue(double d) {
        return new CSSNumericValue(CSSNumericType.PT, d);
    }

    public static CSSNumericValue createValue(CSSNumericType cSSNumericType, double d) {
        return new CSSNumericValue(cSSNumericType, d);
    }
}

