/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.raw;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class RawResourceData
implements ResourceData {
    private ResourceKey rawKey;
    private byte[] data;

    public RawResourceData(ResourceKey rawKey) {
        if (rawKey == null) {
            throw new NullPointerException();
        }
        this.rawKey = rawKey;
        this.data = (byte[])rawKey.getIdentifier();
    }

    @Override
    public byte[] getResource(ResourceManager caller) throws ResourceLoadingException {
        return (byte[])this.data.clone();
    }

    @Override
    public long getLength() {
        return this.data.length;
    }

    @Override
    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public int getResource(ResourceManager caller, byte[] target, long offset, int length) throws ResourceLoadingException {
        if (offset > (long)this.data.length) {
            return -1;
        }
        int iOffset = (int)(Integer.MAX_VALUE & offset);
        int remaining = this.data.length - iOffset;
        int maxReadable = Math.min(target.length, Math.min(remaining, length));
        System.arraycopy(this.data, iOffset, target, 0, maxReadable);
        return maxReadable;
    }

    @Override
    public Object getAttribute(String key) {
        return null;
    }

    @Override
    public ResourceKey getKey() {
        return this.rawKey;
    }

    @Override
    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        return -1L;
    }
}

