/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.pfm;

import java.io.IOException;
import org.pentaho.reporting.libraries.fonts.LEByteAccessUtilities;

public class PfmExtension {
    private int extMetricsOffset;
    private int extentTable;
    private int originTable;
    private int pairKernTable;
    private int trackKernTable;
    private int driverInfo;
    public static final int LENGTH = 30;

    public PfmExtension(byte[] data) throws IOException {
        if (LEByteAccessUtilities.readShort(data, 0) != 30) {
            throw new IOException("Extended-Header must be 30 bytes long.");
        }
        this.extMetricsOffset = LEByteAccessUtilities.readLong(data, 2);
        this.extentTable = LEByteAccessUtilities.readLong(data, 6);
        this.originTable = LEByteAccessUtilities.readLong(data, 10);
        this.pairKernTable = LEByteAccessUtilities.readLong(data, 14);
        this.trackKernTable = LEByteAccessUtilities.readLong(data, 18);
        this.driverInfo = LEByteAccessUtilities.readLong(data, 22);
    }

    public int getExtMetricsOffset() {
        return this.extMetricsOffset;
    }

    public int getExtentTable() {
        return this.extentTable;
    }

    public int getOriginTable() {
        return this.originTable;
    }

    public int getPairKernTable() {
        return this.pairKernTable;
    }

    public int getTrackKernTable() {
        return this.trackKernTable;
    }

    public int getDriverInfo() {
        return this.driverInfo;
    }
}

