/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.content;

import java.io.Serializable;
import java.text.Format;
import java.util.Date;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.statics.FormattedContentToken;
import org.jfree.layouting.layouter.content.statics.StaticTextToken;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.i18n.LocalizationContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionUtilities;
import org.jfree.layouting.layouter.style.functions.content.ContentFunction;
import org.jfree.layouting.layouter.style.values.CSSFormatedValue;
import org.jfree.layouting.layouter.style.values.CSSRawValue;

public class FormatValueFunction
implements ContentFunction {
    @Override
    public ContentToken evaluate(LayoutProcess layoutProcess, LayoutElement layoutElement, CSSFunctionValue cSSFunctionValue) throws FunctionEvaluationException {
        CSSValue[] cSSValueArray = cSSFunctionValue.getParameters();
        if (cSSValueArray.length < 2) {
            throw new FunctionEvaluationException("Illegal parameter count");
        }
        CSSValue cSSValue = FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[0]);
        String string = FunctionUtilities.resolveString(layoutProcess, layoutElement, cSSValueArray[1]);
        LocalizationContext localizationContext = DocumentContextUtility.getLocalizationContext(layoutProcess.getDocumentContext());
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        if ("date".equals(string)) {
            if (cSSValueArray.length < 3) {
                return this.getDateValue(cSSValue, localizationContext.getDateFormat(layoutContext.getLanguage()));
            }
            String string2 = FunctionUtilities.resolveString(layoutProcess, layoutElement, cSSValueArray[2]);
            return this.getDateValue(cSSValue, localizationContext.getDateFormat(string2, layoutContext.getLanguage()));
        }
        if ("time".equals(string)) {
            if (cSSValueArray.length != 2) {
                throw new FunctionEvaluationException();
            }
            return this.getDateValue(cSSValue, localizationContext.getTimeFormat(layoutContext.getLanguage()));
        }
        if ("number".equals(string)) {
            if (cSSValueArray.length < 3) {
                return this.getNumberValue(cSSValue, localizationContext.getDateFormat(layoutContext.getLanguage()));
            }
            String string3 = FunctionUtilities.resolveString(layoutProcess, layoutElement, cSSValueArray[2]);
            return this.getNumberValue(cSSValue, localizationContext.getNumberFormat(string3, layoutContext.getLanguage()));
        }
        if ("integer".equals(string)) {
            if (cSSValueArray.length != 2) {
                throw new FunctionEvaluationException();
            }
            return this.getNumberValue(cSSValue, localizationContext.getIntegerFormat(layoutContext.getLanguage()));
        }
        throw new FunctionEvaluationException("FormatType not recognized");
    }

    private ContentToken getNumberValue(CSSValue cSSValue, Format format) throws FunctionEvaluationException {
        double d;
        Serializable serializable;
        if (cSSValue instanceof CSSStringValue) {
            serializable = (CSSStringValue)cSSValue;
            try {
                CSSNumericValue cSSNumericValue = FunctionUtilities.parseNumberValue(serializable.getValue());
                d = cSSNumericValue.getValue();
            }
            catch (FunctionEvaluationException functionEvaluationException) {
                return new StaticTextToken(serializable.getValue());
            }
        } else if (cSSValue instanceof CSSNumericValue) {
            serializable = (CSSNumericValue)cSSValue;
            d = ((CSSNumericValue)serializable).getValue();
        } else {
            throw new FunctionEvaluationException("Not a numeric value.");
        }
        serializable = new Double(d);
        return new FormattedContentToken(serializable, format, format.format(serializable));
    }

    private FormattedContentToken getDateValue(CSSValue cSSValue, Format format) throws FunctionEvaluationException {
        Date date;
        if (cSSValue instanceof CSSRawValue) {
            CSSRawValue cSSRawValue = (CSSRawValue)cSSValue;
            Object object = cSSRawValue.getValue();
            if (!(object instanceof Date)) {
                throw new FunctionEvaluationException("Not a date value.");
            }
            date = (Date)object;
        } else if (cSSValue instanceof CSSFormatedValue) {
            CSSFormatedValue cSSFormatedValue = (CSSFormatedValue)cSSValue;
            Object object = cSSFormatedValue.getRaw();
            if (!(object instanceof Date)) {
                throw new FunctionEvaluationException("Not a date value.");
            }
            date = (Date)object;
        } else {
            throw new FunctionEvaluationException("Not a date value.");
        }
        return new FormattedContentToken(date, format, format.format(date));
    }
}

