/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.preferences.filesystem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.jfree.report.modules.preferences.base.ConfigFactory;
import org.jfree.report.modules.preferences.base.ConfigStorage;
import org.jfree.report.modules.preferences.base.ConfigStoreException;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;

public class FileConfigStorage
implements ConfigStorage {
    private final File baseDirectory;
    private static final String CONFIGHEADER = "part of the jfreereport filesystem config store";

    public FileConfigStorage(File file) {
        this.baseDirectory = file;
    }

    @Override
    public void store(String string, Configuration configuration) throws ConfigStoreException {
        Object object;
        Object object2;
        if (!ConfigFactory.isValidPath(string)) {
            throw new IllegalArgumentException("The give path is not valid.");
        }
        Enumeration enumeration = configuration.getConfigProperties();
        Properties properties = new Properties();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = configuration.getConfigProperty((String)object2);
            if (object == null || object2 == null) continue;
            properties.put(object2, object);
        }
        object2 = new File(this.baseDirectory, string);
        if (((File)object2).exists() && !((File)object2).canWrite()) {
            return;
        }
        try {
            object = new BufferedOutputStream(new FileOutputStream((File)object2));
            properties.store((OutputStream)object, CONFIGHEADER);
            ((OutputStream)object).close();
        }
        catch (Exception exception) {
            throw new ConfigStoreException("Failed to write config " + string, exception);
        }
    }

    @Override
    public Configuration load(String string, Configuration configuration) throws ConfigStoreException {
        if (!ConfigFactory.isValidPath(string)) {
            throw new IllegalArgumentException("The given path is not valid.");
        }
        try {
            Properties properties = new Properties();
            File file = new File(this.baseDirectory, string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            properties.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
            HierarchicalConfiguration hierarchicalConfiguration = new HierarchicalConfiguration(configuration);
            for (String string2 : properties.keySet()) {
                hierarchicalConfiguration.setConfigProperty(string2, properties.getProperty(string2));
            }
            return hierarchicalConfiguration;
        }
        catch (Exception exception) {
            throw new ConfigStoreException("Failed to read config" + string, exception);
        }
    }

    @Override
    public boolean isAvailable(String string) {
        if (!ConfigFactory.isValidPath(string)) {
            throw new IllegalArgumentException("The give path is not valid.");
        }
        File file = new File(this.baseDirectory, string);
        return file.exists() && file.canRead();
    }

    public String toString() {
        return "FileConfigStorage={baseDir=" + this.baseDirectory + "}";
    }
}

