/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.helper;

import com.sun.star.comp.helper.ComponentContextEntry;
import com.sun.star.comp.helper.Disposer;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.DeploymentException;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

public class ComponentContext
implements XComponentContext,
XComponent {
    private static final boolean DEBUG = false;
    private static final String SMGR_NAME = "/singletons/com.sun.star.lang.theServiceManager";
    private static final String TDMGR_NAME = "/singletons/com.sun.star.reflection.theTypeDescriptionManager";
    private Map<String, Object> m_table;
    private XComponentContext m_xDelegate;
    private XMultiComponentFactory m_xSMgr;
    private boolean m_bDisposeSMgr;
    private ArrayList<XEventListener> m_eventListener = new ArrayList();

    public ComponentContext(Hashtable<String, Object> hashtable, XComponentContext xComponentContext) {
        this((Map<String, Object>)hashtable, xComponentContext);
    }

    public ComponentContext(Map<String, Object> map, XComponentContext xComponentContext) {
        this.m_table = map;
        this.m_xDelegate = xComponentContext;
        this.m_xSMgr = null;
        this.m_bDisposeSMgr = false;
        Object object = map.get(SMGR_NAME);
        if (object != null) {
            if (object instanceof ComponentContextEntry) {
                object = ((ComponentContextEntry)object).m_value;
            }
            this.m_xSMgr = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)object);
        }
        if (this.m_xSMgr != null) {
            this.m_bDisposeSMgr = true;
        } else if (this.m_xDelegate != null) {
            this.m_xSMgr = this.m_xDelegate.getServiceManager();
        }
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.m_xDelegate);
        if (xComponent != null) {
            xComponent.addEventListener((XEventListener)new Disposer(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueByName(String string) {
        XSingleComponentFactory xSingleComponentFactory;
        Object object;
        Object object2 = this.m_table.get(string);
        if (object2 == null) {
            if (this.m_xDelegate != null) {
                return this.m_xDelegate.getValueByName(string);
            }
            return Any.VOID;
        }
        if (!(object2 instanceof ComponentContextEntry)) {
            return object2;
        }
        ComponentContextEntry componentContextEntry = (ComponentContextEntry)object2;
        if (componentContextEntry.m_lateInit == null) {
            return componentContextEntry.m_value;
        }
        Object object3 = null;
        try {
            object = (String)componentContextEntry.m_lateInit;
            if (object != null) {
                if (this.m_xSMgr != null) {
                    object3 = this.m_xSMgr.createInstanceWithContext((String)object, (XComponentContext)this);
                }
            } else {
                xSingleComponentFactory = (XSingleComponentFactory)UnoRuntime.queryInterface(XSingleComponentFactory.class, (Object)componentContextEntry.m_lateInit);
                if (xSingleComponentFactory != null) {
                    object3 = xSingleComponentFactory.createInstanceWithContext((XComponentContext)this);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object3 != null) {
            object = componentContextEntry;
            synchronized (object) {
                if (componentContextEntry.m_lateInit != null) {
                    componentContextEntry.m_value = object3;
                    componentContextEntry.m_lateInit = null;
                } else {
                    xSingleComponentFactory = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)object3);
                    if (xSingleComponentFactory != null) {
                        xSingleComponentFactory.dispose();
                    }
                }
            }
        }
        return componentContextEntry.m_value;
    }

    public XMultiComponentFactory getServiceManager() {
        if (this.m_xSMgr == null) {
            throw new DeploymentException("null component context service manager");
        }
        return this.m_xSMgr;
    }

    public void dispose() {
        XComponent xComponent;
        EventObject eventObject = new EventObject((Object)this);
        for (XEventListener object2 : this.m_eventListener) {
            object2.disposing(eventObject);
        }
        this.m_eventListener.clear();
        XComponent xComponent2 = null;
        for (Map.Entry<String, Object> entry : this.m_table.entrySet()) {
            XComponent xComponent3;
            String string = entry.getKey();
            if (string.equals(SMGR_NAME)) continue;
            Object object = entry.getValue();
            if (object instanceof ComponentContextEntry) {
                object = ((ComponentContextEntry)object).m_value;
            }
            if ((xComponent3 = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)object)) == null) continue;
            if (string.equals(TDMGR_NAME)) {
                xComponent2 = xComponent3;
                continue;
            }
            xComponent3.dispose();
        }
        this.m_table.clear();
        if (this.m_bDisposeSMgr && (xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.m_xSMgr)) != null) {
            xComponent.dispose();
        }
        this.m_xSMgr = null;
        if (xComponent2 != null) {
            xComponent2.dispose();
        }
    }

    public void addEventListener(XEventListener xEventListener) {
        if (xEventListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (this.m_eventListener.contains(xEventListener)) {
            throw new RuntimeException("Listener already registered.");
        }
        this.m_eventListener.add(xEventListener);
    }

    public void removeEventListener(XEventListener xEventListener) {
        if (xEventListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (!this.m_eventListener.contains(xEventListener)) {
            throw new RuntimeException("Listener is not registered.");
        }
        this.m_eventListener.remove(xEventListener);
    }
}

