/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.StyleKey;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class StyleKeyRegistry {
    private static StyleKeyRegistry registry;
    private HashMap knownStyleKeys = new HashMap();

    public static synchronized StyleKeyRegistry getRegistry() {
        if (registry == null) {
            registry = new StyleKeyRegistry();
            registry.registerDefaults();
        }
        return registry;
    }

    private StyleKeyRegistry() {
    }

    public StyleKey findKeyByName(String string) {
        return (StyleKey)this.knownStyleKeys.get(string);
    }

    public int getIndexForKey(StyleKey styleKey) {
        Integer n = (Integer)this.knownStyleKeys.get(styleKey.getName());
        if (n != null) {
            return n;
        }
        throw new IllegalStateException("This key is not registered. How could that be?");
    }

    public int getKeyCount() {
        return this.knownStyleKeys.size();
    }

    public synchronized void registerDefaults() {
        Configuration configuration = LibLayoutBoot.getInstance().getGlobalConfig();
        Iterator iterator = configuration.findPropertyKeys("org.jfree.layouting.stylekeys.");
        ClassLoader classLoader = ObjectUtilities.getClassLoader(StyleKeyRegistry.class);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Class<?> clazz = classLoader.loadClass(configuration.getConfigProperty(string));
                this.registerClass(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public synchronized void registerClass(Class clazz) {
        try {
            Field[] fieldArray = clazz.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                int n = field.getModifiers();
                if (!Modifier.isPublic(n) || !Modifier.isStatic(n)) continue;
                if (!Modifier.isFinal(n)) {
                    DebugLog.log((Object)("Invalid implementation: StyleKeys should be 'public static final': " + clazz));
                }
                if (!field.getType().isAssignableFrom(StyleKey.class)) continue;
                StyleKey styleKey = (StyleKey)field.get(null);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public synchronized StyleKey createKey(String string, boolean bl, boolean bl2, int n) {
        StyleKey styleKey = this.findKeyByName(string);
        if (styleKey != null) {
            return styleKey;
        }
        StyleKey styleKey2 = new StyleKey(string, bl, bl2, this.knownStyleKeys.size(), n);
        this.knownStyleKeys.put(string, styleKey2);
        return styleKey2;
    }

    public synchronized StyleKey[] getKeys() {
        return this.getKeys(new StyleKey[this.knownStyleKeys.size()]);
    }

    public synchronized StyleKey[] getKeys(StyleKey[] styleKeyArray) {
        return this.knownStyleKeys.values().toArray(styleKeyArray);
    }
}

