/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.keys.page.PageBreak;
import org.jfree.layouting.input.style.keys.page.PageStyleKeys;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.keys.text.WhitespaceCollapse;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.BoxLayoutProperties;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.StaticBoxLayoutProperties;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;
import org.jfree.layouting.renderer.text.TextUtility;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;

public abstract class RenderBox
extends RenderNode {
    private static final Log logger = LogFactory.getLog(RenderBox.class);
    public static final boolean LOG_PRUNE = false;
    private RenderNode firstChild;
    private RenderNode lastChild;
    private boolean open;
    private PageContext pageContext;
    private BoxLayoutProperties boxLayoutProperties;
    private StaticBoxLayoutProperties staticBoxLayoutProperties;
    private long contentAreaX1;
    private long contentAreaX2;
    private BoxDefinition boxDefinition;
    private int lineCount;
    private ExtendedBaselineInfo baselineInfo;
    private long widowsSize;
    private long orphansSize;

    public RenderBox(BoxDefinition boxDefinition) {
        if (boxDefinition == null) {
            throw new NullPointerException("BoxDefinition must not be null");
        }
        this.boxDefinition = boxDefinition;
        this.open = true;
        this.staticBoxLayoutProperties = new StaticBoxLayoutProperties();
    }

    public StaticBoxLayoutProperties getStaticBoxLayoutProperties() {
        return this.staticBoxLayoutProperties;
    }

    @Override
    public void appyStyle(LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        super.appyStyle(layoutContext, outputProcessorMetaData);
        this.staticBoxLayoutProperties.setPreserveSpace(WhitespaceCollapse.PRESERVE.equals(layoutContext.getValue(TextStyleKeys.WHITE_SPACE_COLLAPSE)));
        this.staticBoxLayoutProperties.setDominantBaseline(layoutContext.getValue(LineStyleKeys.DOMINANT_BASELINE));
        FontSpecification fontSpecification = layoutContext.getFontSpecification();
        FontMetrics fontMetrics = outputProcessorMetaData.getFontMetrics(fontSpecification);
        this.staticBoxLayoutProperties.setNominalBaselineInfo(TextUtility.createBaselineInfo(120, fontMetrics));
        CSSValue cSSValue = layoutContext.getValue(PageStyleKeys.WIDOWS);
        this.staticBoxLayoutProperties.setWidows(Math.max(1, (int)CSSValueResolverUtility.getNumericValue(cSSValue, 0.0)));
        CSSValue cSSValue2 = layoutContext.getValue(PageStyleKeys.ORPHANS);
        this.staticBoxLayoutProperties.setOrphans(Math.max(1, (int)CSSValueResolverUtility.getNumericValue(cSSValue2, 0.0)));
        CSSValue cSSValue3 = layoutContext.getValue(PageStyleKeys.PAGE_BREAK_INSIDE);
        this.staticBoxLayoutProperties.setAvoidPagebreakInside(PageBreak.AVOID.equals(cSSValue3));
    }

    public long getWidowsSize() {
        return this.widowsSize;
    }

    public void setWidowsSize(long l) {
        this.widowsSize = l;
    }

    public long getOrphansSize() {
        return this.orphansSize;
    }

    public void setOrphansSize(long l) {
        this.orphansSize = l;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int n) {
        this.lineCount = n;
    }

    public int getWidows() {
        return this.staticBoxLayoutProperties.getWidows();
    }

    public int getOrphans() {
        return this.staticBoxLayoutProperties.getOrphans();
    }

    public boolean isAvoidPagebreakInside() {
        return this.staticBoxLayoutProperties.isAvoidPagebreakInside();
    }

    public ExtendedBaselineInfo getBaselineInfo() {
        return this.baselineInfo;
    }

    public void setBaselineInfo(ExtendedBaselineInfo extendedBaselineInfo) {
        this.baselineInfo = extendedBaselineInfo;
    }

    public ExtendedBaselineInfo getNominalBaselineInfo() {
        return this.staticBoxLayoutProperties.getNominalBaselineInfo();
    }

    public CSSValue getDominantBaseline() {
        return this.staticBoxLayoutProperties.getDominantBaseline();
    }

    public boolean isPreserveSpace() {
        return this.staticBoxLayoutProperties.isPreserveSpace();
    }

    public BoxDefinition getBoxDefinition() {
        return this.boxDefinition;
    }

    public RenderNode getFirstChild() {
        return this.firstChild;
    }

    protected void setFirstChild(RenderNode renderNode) {
        this.firstChild = renderNode;
    }

    public RenderNode getLastChild() {
        return this.lastChild;
    }

    protected void setLastChild(RenderNode renderNode) {
        this.lastChild = renderNode;
    }

    public void addGeneratedChild(RenderNode renderNode) {
        if (renderNode == null) {
            throw new NullPointerException("Child to be added must not be null.");
        }
        if (this.isHibernated()) {
            throw new IllegalStateException("Check your state management, you've messed with an hibernated element.");
        }
        if (this.lastChild != null) {
            this.lastChild.setNext(renderNode);
        }
        renderNode.setPrev(this.lastChild);
        renderNode.setNext(null);
        this.lastChild = renderNode;
        if (this.firstChild == null) {
            this.firstChild = renderNode;
        }
        renderNode.setParent(this);
        if (this.isFrozen()) {
            renderNode.freeze();
        }
        renderNode.updateChangeTracker();
    }

    public void addChild(RenderNode renderNode) {
        if (renderNode == null) {
            throw new NullPointerException("Child to be added must not be null.");
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Adding content to an already closed element.");
        }
        if (this.isHibernated()) {
            throw new IllegalStateException("Check your state management. You tried to modify a hibernated element.");
        }
        if (this.lastChild != null) {
            this.lastChild.setNext(renderNode);
        }
        renderNode.setPrev(this.lastChild);
        renderNode.setNext(null);
        this.lastChild = renderNode;
        if (this.firstChild == null) {
            this.firstChild = renderNode;
        }
        renderNode.setParent(this);
        if (this.isFrozen()) {
            renderNode.freeze();
        }
        renderNode.updateChangeTracker();
    }

    protected void insertAfter(RenderNode renderNode, RenderNode renderNode2) {
        if (renderNode == null) {
            RenderNode renderNode3 = this.getFirstChild();
            if (renderNode3 == null) {
                this.setLastChild(renderNode2);
                this.setFirstChild(renderNode2);
                renderNode2.setParent(this);
                renderNode2.setPrev(null);
                renderNode2.setNext(null);
                renderNode2.updateChangeTracker();
                return;
            }
            renderNode3.setPrev(renderNode2);
            this.setFirstChild(renderNode2);
            renderNode2.setParent(this);
            renderNode2.setPrev(null);
            renderNode2.setNext(renderNode3);
            renderNode2.updateChangeTracker();
            return;
        }
        if (renderNode.getParent() != this) {
            throw new IllegalStateException("You made a big boo");
        }
        RenderNode renderNode4 = renderNode.getNext();
        renderNode.setNext(renderNode2);
        renderNode2.setPrev(renderNode);
        renderNode2.setParent(this);
        renderNode2.setNext(renderNode4);
        if (renderNode4 != null) {
            renderNode4.setPrev(renderNode2);
        } else {
            this.setLastChild(renderNode2);
        }
        renderNode2.updateChangeTracker();
    }

    protected void insertBefore(RenderNode renderNode, RenderNode renderNode2) {
        if (renderNode == null) {
            RenderNode renderNode3 = this.getLastChild();
            if (renderNode3 == null) {
                renderNode2.setParent(this);
                renderNode2.setPrev(null);
                renderNode2.setNext(null);
                this.setFirstChild(renderNode2);
                this.setLastChild(renderNode2);
                renderNode2.updateChangeTracker();
                return;
            }
            this.setLastChild(renderNode2);
            renderNode2.setParent(this);
            renderNode2.setPrev(renderNode3);
            renderNode2.setNext(null);
            renderNode3.setNext(renderNode2);
            renderNode2.updateChangeTracker();
            return;
        }
        if (renderNode.getParent() != this) {
            throw new IllegalStateException("You made a big boo");
        }
        RenderNode renderNode4 = renderNode.getPrev();
        renderNode.setPrev(renderNode2);
        renderNode2.setNext(renderNode);
        renderNode2.setParent(this);
        renderNode2.setPrev(renderNode4);
        if (renderNode4 != null) {
            renderNode4.setNext(renderNode2);
        } else {
            this.setFirstChild(renderNode2);
        }
        renderNode2.updateChangeTracker();
    }

    public void replaceChild(RenderNode renderNode, RenderNode renderNode2) {
        if (renderNode.getParent() != this) {
            throw new IllegalArgumentException("None of my childs.");
        }
        if (renderNode == renderNode2) {
            return;
        }
        boolean bl = false;
        if (renderNode == this.firstChild) {
            renderNode2.setNext(this.firstChild.getNext());
            renderNode2.setPrev(null);
            this.firstChild.setNext(null);
            this.firstChild.setPrev(null);
            this.firstChild = renderNode2;
            renderNode2.setParent(this);
            bl = true;
        }
        if (renderNode == this.lastChild) {
            renderNode2.setPrev(this.lastChild.getPrev());
            renderNode2.setNext(null);
            this.lastChild.setNext(null);
            this.lastChild.setPrev(null);
            this.lastChild = renderNode2;
            renderNode2.setParent(this);
            bl = true;
        }
        if (bl) {
            renderNode.updateChangeTracker();
            renderNode2.updateChangeTracker();
            return;
        }
        RenderNode renderNode3 = renderNode.getPrev();
        RenderNode renderNode4 = renderNode.getNext();
        renderNode2.setPrev(renderNode3);
        renderNode2.setNext(renderNode4);
        if (renderNode3 != null) {
            renderNode3.setNext(renderNode2);
        }
        if (renderNode4 != null) {
            renderNode4.setPrev(renderNode2);
        }
        renderNode2.setParent(this);
        renderNode.updateChangeTracker();
        renderNode2.updateChangeTracker();
    }

    public void replaceChilds(RenderNode renderNode, RenderNode[] renderNodeArray) {
        RenderNode renderNode2;
        int n;
        if (renderNode.getParent() != this) {
            throw new IllegalArgumentException("None of my childs.");
        }
        if (renderNodeArray.length == 0) {
            throw new IndexOutOfBoundsException("Array is empty ..");
        }
        if (renderNode == renderNodeArray[0]) {
            if (renderNodeArray.length == 1) {
                return;
            }
            throw new IllegalArgumentException("Thou shall not use the replace method to insert new elements!");
        }
        RenderNode renderNode3 = null;
        RenderNode renderNode4 = null;
        for (n = 0; n < renderNodeArray.length; ++n) {
            if (renderNode4 == null) {
                renderNode4 = renderNodeArray[n];
                if (renderNode4 == null) continue;
                renderNode3 = renderNode4;
                renderNode3.setParent(this);
                continue;
            }
            renderNode2 = renderNodeArray[n];
            renderNode4.setNext(renderNode2);
            renderNode2.setPrev(renderNode4);
            renderNode2.setParent(this);
            renderNode4 = renderNode2;
        }
        if (renderNode3 == null) {
            throw new IndexOutOfBoundsException("Array is empty (NullValues stripped)..");
        }
        if (renderNode == this.firstChild) {
            RenderNode renderNode5 = this.firstChild.getNext();
            renderNode4.setNext(renderNode5);
            renderNode3.setPrev(null);
            if (renderNode5 != null) {
                renderNode5.setPrev(renderNode4);
            } else {
                this.lastChild = renderNode4;
            }
            this.firstChild.setNext(null);
            this.firstChild.setPrev(null);
            this.firstChild = renderNode3;
            renderNode.updateChangeTracker();
            for (int i = 0; i < renderNodeArray.length; ++i) {
                RenderNode renderNode6 = renderNodeArray[i];
                renderNode6.updateChangeTracker();
            }
            return;
        }
        if (renderNode == this.lastChild) {
            renderNode3.setPrev(this.lastChild.getPrev());
            renderNode4.setNext(null);
            this.lastChild.setNext(null);
            this.lastChild.setPrev(null);
            this.lastChild = renderNode4;
            for (n = 0; n < renderNodeArray.length; ++n) {
                renderNode2 = renderNodeArray[n];
                renderNode2.updateChangeTracker();
            }
            return;
        }
        RenderNode renderNode7 = renderNode.getPrev();
        renderNode2 = renderNode.getNext();
        renderNode3.setPrev(renderNode7);
        renderNode4.setNext(renderNode2);
        if (renderNode7 != null) {
            renderNode7.setNext(renderNode3);
        }
        if (renderNode2 != null) {
            renderNode2.setPrev(renderNode4);
        }
        for (int i = 0; i < renderNodeArray.length; ++i) {
            RenderNode renderNode8 = renderNodeArray[i];
            renderNode8.updateChangeTracker();
        }
    }

    @Override
    public Object clone() {
        try {
            RenderBox renderBox = (RenderBox)super.clone();
            if (this.boxLayoutProperties != null) {
                renderBox.boxLayoutProperties = (BoxLayoutProperties)this.boxLayoutProperties.clone();
            }
            return renderBox;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public RenderNode derive(boolean bl) {
        RenderBox renderBox = (RenderBox)super.derive(bl);
        if (bl) {
            RenderNode renderNode = null;
            for (RenderNode renderNode2 = this.firstChild; renderNode2 != null; renderNode2 = renderNode2.getNext()) {
                RenderNode renderNode3 = renderNode;
                renderNode = renderNode2.derive(true);
                renderNode.setParent(renderBox);
                if (renderNode3 == null) {
                    renderBox.firstChild = renderNode;
                    renderNode.setPrev(null);
                    continue;
                }
                renderNode3.setNext(renderNode);
                renderNode.setPrev(renderNode3);
            }
            renderBox.lastChild = renderNode;
            if (this.lastChild != null) {
                renderBox.lastChild.setNext(null);
            }
        } else {
            renderBox.firstChild = null;
            renderBox.lastChild = null;
        }
        return renderBox;
    }

    @Override
    public RenderNode hibernate() {
        RenderBox renderBox = (RenderBox)super.hibernate();
        RenderNode renderNode = null;
        for (RenderNode renderNode2 = this.firstChild; renderNode2 != null; renderNode2 = renderNode2.getNext()) {
            RenderNode renderNode3 = renderNode;
            renderNode = renderNode2.hibernate();
            renderNode.setParent(renderBox);
            if (renderNode3 == null) {
                renderBox.firstChild = renderNode;
                renderNode.setPrev(null);
                continue;
            }
            renderNode3.setNext(renderNode);
            renderNode.setPrev(renderNode3);
        }
        renderBox.lastChild = renderNode;
        if (this.lastChild != null) {
            renderBox.lastChild.setNext(null);
        }
        return renderBox;
    }

    @Override
    public RenderNode deriveFrozen(boolean bl) {
        RenderBox renderBox = (RenderBox)super.deriveFrozen(bl);
        if (bl) {
            RenderNode renderNode = null;
            for (RenderNode renderNode2 = this.firstChild; renderNode2 != null; renderNode2 = renderNode2.getNext()) {
                RenderNode renderNode3 = renderNode;
                renderNode = renderNode2.deriveFrozen(true);
                renderNode.setParent(renderBox);
                if (renderNode3 == null) {
                    renderBox.firstChild = renderNode;
                    renderNode.setPrev(null);
                    continue;
                }
                renderNode3.setNext(renderNode);
                renderNode.setPrev(renderNode3);
            }
            renderBox.lastChild = renderNode;
            if (this.lastChild != null) {
                renderBox.lastChild.setNext(null);
            }
        } else {
            renderBox.firstChild = null;
            renderBox.lastChild = null;
        }
        return renderBox;
    }

    public void addChilds(RenderNode[] renderNodeArray) {
        for (int i = 0; i < renderNodeArray.length; ++i) {
            this.addChild(renderNodeArray[i]);
        }
    }

    @Override
    public RenderNode findNodeById(Object object) {
        if (object == this.getInstanceId()) {
            return this;
        }
        for (RenderNode renderNode = this.getLastChild(); renderNode != null; renderNode = renderNode.getPrev()) {
            RenderNode renderNode2 = renderNode.findNodeById(object);
            if (renderNode2 == null) continue;
            return renderNode2;
        }
        return null;
    }

    public boolean isAppendable() {
        return this.isOpen();
    }

    public RenderBox getInsertationPoint() {
        RenderBox renderBox;
        if (!this.isAppendable()) {
            throw new IllegalStateException("Already closed");
        }
        RenderNode renderNode = this.getLastChild();
        if (renderNode instanceof RenderBox && (renderBox = (RenderBox)renderNode).isAppendable()) {
            return renderBox.getInsertationPoint();
        }
        return this;
    }

    public Border getBorder() {
        return this.boxDefinition.getBorder();
    }

    public void clear() {
        RenderNode renderNode = this.getFirstChild();
        while (renderNode != null) {
            RenderNode renderNode2 = renderNode.getNext();
            if (renderNode != this.getFirstChild()) {
                renderNode.getPrev().setNext(null);
            }
            renderNode.setPrev(null);
            renderNode.setParent(null);
            renderNode = renderNode2;
        }
        this.setFirstChild(null);
        this.setLastChild(null);
        this.updateChangeTracker();
    }

    public RenderNode getVisibleFirst() {
        for (RenderNode renderNode = this.getFirstChild(); renderNode != null; renderNode = renderNode.getNext()) {
            if (renderNode.isIgnorableForRendering()) continue;
            return renderNode;
        }
        return null;
    }

    public RenderNode getVisibleLast() {
        for (RenderNode renderNode = this.getLastChild(); renderNode != null; renderNode = renderNode.getPrev()) {
            if (renderNode.isIgnorableForRendering()) continue;
            return renderNode;
        }
        return null;
    }

    private RenderNode getFirstNonEmpty() {
        for (RenderNode renderNode = this.getFirstChild(); renderNode != null; renderNode = renderNode.getNext()) {
            if (renderNode.isEmpty()) continue;
            return renderNode;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        if (!this.getBoxDefinition().isEmpty()) {
            return false;
        }
        RenderNode renderNode = this.getFirstNonEmpty();
        return renderNode == null;
    }

    @Override
    public boolean isDiscardable() {
        if (!this.getBoxDefinition().isEmpty()) {
            return false;
        }
        for (RenderNode renderNode = this.getFirstChild(); renderNode != null; renderNode = renderNode.getNext()) {
            if (renderNode.isDiscardable()) continue;
            return false;
        }
        return true;
    }

    public void close() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Double close..");
        }
        if (this.isHibernated()) {
            throw new IllegalStateException("Check your state management. You tried to mess with an hibernated element.");
        }
        this.open = false;
        if (this.isDiscardable()) {
            if (this.getParent() != null) {
                this.getParent().remove(this);
            }
        } else {
            RenderNode renderNode = this.getLastChild();
            while (renderNode != null && renderNode.isDiscardable()) {
                this.remove(renderNode);
                renderNode = this.getLastChild();
            }
        }
    }

    public void remove(RenderNode renderNode) {
        RenderBox renderBox = renderNode.getParent();
        if (renderBox != this) {
            throw new IllegalArgumentException("None of my childs");
        }
        renderNode.setParent(null);
        RenderNode renderNode2 = renderNode.getPrev();
        RenderNode renderNode3 = renderNode.getNext();
        if (renderNode2 != null) {
            renderNode2.setNext(renderNode3);
        }
        if (renderNode3 != null) {
            renderNode3.setPrev(renderNode2);
        }
        if (this.firstChild == renderNode) {
            this.firstChild = renderNode3;
        }
        if (this.lastChild == renderNode) {
            this.lastChild = renderNode2;
        }
        renderNode.updateChangeTracker();
        this.updateChangeTracker();
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public PageContext getPageContext() {
        if (this.pageContext != null) {
            return this.pageContext;
        }
        return super.getPageContext();
    }

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    @Override
    public void freeze() {
        if (this.isFrozen()) {
            return;
        }
        super.freeze();
        for (RenderNode renderNode = this.getFirstChild(); renderNode != null; renderNode = renderNode.getNext()) {
            renderNode.freeze();
        }
    }

    public BoxLayoutProperties getBoxLayoutProperties() {
        if (this.boxLayoutProperties == null) {
            this.boxLayoutProperties = new BoxLayoutProperties();
        }
        return this.boxLayoutProperties;
    }

    public long getContentAreaX1() {
        return this.contentAreaX1;
    }

    public void setContentAreaX1(long l) {
        this.contentAreaX1 = l;
    }

    public long getContentAreaX2() {
        return this.contentAreaX2;
    }

    public void setContentAreaX2(long l) {
        if (l < 0L) {
            throw new IllegalStateException("Failure here: " + l);
        }
        this.contentAreaX2 = l;
    }

    public RenderBox split(int n) {
        RenderBox renderBox = (RenderBox)this.derive(false);
        BoxDefinition[] boxDefinitionArray = this.boxDefinition.split(n);
        this.boxDefinition = boxDefinitionArray[0];
        renderBox.boxDefinition = boxDefinitionArray[1];
        return renderBox;
    }

    @Override
    public long getEffectiveMarginTop() {
        return this.getBoxLayoutProperties().getEffectiveMarginTop();
    }

    @Override
    public long getEffectiveMarginBottom() {
        return this.getBoxLayoutProperties().getEffectiveMarginBottom();
    }
}

