/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

class VariableNode {
    Scriptable scope;
    String name;
    int index;
    Object[] children;
    static final Object[] empty = new Object[0];

    public VariableNode(Scriptable scope, String name) {
        this.scope = scope;
        this.name = name;
    }

    public VariableNode(Scriptable scope, int index) {
        this.scope = scope;
        this.name = null;
        this.index = index;
    }

    public String toString() {
        return this.name != null ? this.name : "[" + this.index + "]";
    }

    public Object getObject() {
        try {
            if (this.scope == null) {
                return null;
            }
            if (this.name != null) {
                if (this.name.equals("this")) {
                    return this.scope;
                }
                Object result = ScriptableObject.NOT_FOUND;
                if (this.name.equals("__proto__")) {
                    result = this.scope.getPrototype();
                } else if (this.name.equals("__parent__")) {
                    result = this.scope.getParentScope();
                } else {
                    try {
                        result = ScriptableObject.getProperty(this.scope, this.name);
                    }
                    catch (RuntimeException e) {
                        result = e.getMessage();
                    }
                }
                if (result == ScriptableObject.NOT_FOUND) {
                    result = Undefined.instance;
                }
                return result;
            }
            Object result = ScriptableObject.getProperty(this.scope, this.index);
            if (result == ScriptableObject.NOT_FOUND) {
                result = Undefined.instance;
            }
            return result;
        }
        catch (Exception exc) {
            return "undefined";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getChildren() {
        if (this.children != null) {
            return this.children;
        }
        Context cx = Context.enter();
        try {
            Object value = this.getObject();
            if (value == null) {
                this.children = empty;
                Object[] objectArray = empty;
                return objectArray;
            }
            if (value == ScriptableObject.NOT_FOUND || value == Undefined.instance) {
                this.children = empty;
                Object[] objectArray = empty;
                return objectArray;
            }
            if (value instanceof Scriptable) {
                Scriptable scrip = (Scriptable)value;
                Scriptable proto = scrip.getPrototype();
                Scriptable parent = scrip.getParentScope();
                if (scrip.has(0, scrip)) {
                    int len = 0;
                    try {
                        Scriptable start;
                        Scriptable obj = start = scrip;
                        Object result = Undefined.instance;
                        while (!(obj.has("length", start) && (result = obj.get("length", start)) != Scriptable.NOT_FOUND || (obj = obj.getPrototype()) == null)) {
                        }
                        if (result instanceof Number) {
                            len = ((Number)result).intValue();
                        }
                    }
                    catch (Exception start) {
                        // empty catch block
                    }
                    if (parent != null) {
                        ++len;
                    }
                    if (proto != null) {
                        ++len;
                    }
                    this.children = new VariableNode[len];
                    int i = 0;
                    int j = 0;
                    if (parent != null) {
                        this.children[i++] = new VariableNode(scrip, "__parent__");
                        ++j;
                    }
                    if (proto != null) {
                        this.children[i++] = new VariableNode(scrip, "__proto__");
                        ++j;
                    }
                    while (i < len) {
                        this.children[i] = new VariableNode(scrip, i - j);
                        ++i;
                    }
                } else {
                    int len = 0;
                    Hashtable<Object, Object> t = new Hashtable<Object, Object>();
                    Object[] ids = scrip instanceof ScriptableObject ? ((ScriptableObject)scrip).getAllIds() : scrip.getIds();
                    if (ids == null) {
                        ids = empty;
                    }
                    if (proto != null) {
                        t.put("__proto__", "__proto__");
                    }
                    if (parent != null) {
                        t.put("__parent__", "__parent__");
                    }
                    if (ids.length > 0) {
                        for (int j = 0; j < ids.length; ++j) {
                            t.put(ids[j], ids[j]);
                        }
                    }
                    ids = new Object[t.size()];
                    Enumeration e = t.keys();
                    int j = 0;
                    while (e.hasMoreElements()) {
                        ids[j++] = e.nextElement().toString();
                    }
                    if (ids != null && ids.length > 0) {
                        Arrays.sort(ids, new Comparator(){

                            public int compare(Object l, Object r) {
                                return l.toString().compareToIgnoreCase(r.toString());
                            }
                        });
                        len = ids.length;
                    }
                    this.children = new VariableNode[len];
                    for (int i = 0; i < len; ++i) {
                        Object id = ids[i];
                        this.children[i] = new VariableNode(scrip, id.toString());
                    }
                }
            }
            cx.exit();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        finally {
            cx.exit();
        }
        return this.children;
    }
}

