/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.afm;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.pentaho.reporting.libraries.fonts.afm.AfmCharMetricsSection;
import org.pentaho.reporting.libraries.fonts.afm.AfmCompositeCharDataSection;
import org.pentaho.reporting.libraries.fonts.afm.AfmDirectionSection;
import org.pentaho.reporting.libraries.fonts.afm.AfmHeader;
import org.pentaho.reporting.libraries.fonts.afm.AfmKernDataSection;
import org.pentaho.reporting.libraries.fonts.afm.AfmParseUtilities;
import org.pentaho.reporting.libraries.fonts.afm.FontDataAsciiReader;
import org.pentaho.reporting.libraries.fonts.io.FileFontDataInputSource;
import org.pentaho.reporting.libraries.fonts.io.FontDataInputSource;

public class AfmFont
implements Serializable {
    private static final int PRE_HEADER = 0;
    private static final int IN_HEADER = 1;
    private static final int IN_METRICS = 2;
    private static final int IN_KERNDATA = 3;
    private static final int IN_COMPOSITES = 4;
    private static final int END_OF_FILE = 5;
    private static final int IN_DIRECTION = 6;
    private AfmHeader header;
    private AfmDirectionSection[] directionSections;
    private AfmCharMetricsSection charMetricsSection;
    private AfmKernDataSection kernDataSection;
    private AfmCompositeCharDataSection compositeCharDataSection;
    private boolean embeddable;
    private String fontName;
    private String familyName;
    private String filename;
    private FontDataInputSource input;

    public AfmFont(File font, boolean embeddable) throws IOException {
        FileFontDataInputSource fis = new FileFontDataInputSource(font);
        this.initialize(fis, embeddable);
        fis.dispose();
    }

    public AfmFont(FontDataInputSource inputSource, boolean embeddable) throws IOException {
        this.initialize(inputSource, embeddable);
    }

    private void initialize(FontDataInputSource inputSource, boolean embeddable) throws IOException {
        if (inputSource == null) {
            throw new NullPointerException();
        }
        this.filename = inputSource.getFileName();
        this.input = inputSource;
        this.embeddable = embeddable;
        this.header = new AfmHeader();
        this.directionSections = new AfmDirectionSection[2];
        this.directionSections[0] = new AfmDirectionSection();
        this.directionSections[1] = new AfmDirectionSection();
        this.charMetricsSection = new AfmCharMetricsSection();
        this.kernDataSection = new AfmKernDataSection();
        this.parseFontFile(inputSource);
        this.fontName = this.header.getFontName();
        if (this.fontName == null) {
            throw new IOException("This font does not define a font-name, therefore it is invalid.");
        }
        this.familyName = this.header.getFamilyName();
        if (this.familyName == null) {
            this.familyName = this.fontName;
        }
    }

    private void parseFontFile(FontDataInputSource inputSource) throws IOException {
        String line;
        int parseState = 0;
        int sectionType = 0;
        FontDataAsciiReader reader = new FontDataAsciiReader(inputSource);
        block14: while ((line = reader.readLine()) != null) {
            if (line.length() == 0) continue;
            switch (parseState) {
                case 0: {
                    if (!line.startsWith("StartFontMetrics")) {
                        throw new IOException("Expected 'StartMetrics' as initial command line.");
                    }
                    parseState = 1;
                    continue block14;
                }
                case 1: {
                    if (line.startsWith("EndFontMetrics")) {
                        parseState = 5;
                        continue block14;
                    }
                    if (line.startsWith("StartDirection")) {
                        parseState = 6;
                        sectionType = AfmParseUtilities.parseInt("StartDirection ", line);
                        continue block14;
                    }
                    if (line.startsWith("StartCharMetrics")) {
                        parseState = 2;
                        sectionType = AfmParseUtilities.parseInt("StartCharMetrics ", line);
                        continue block14;
                    }
                    if (line.startsWith("StartKernData")) {
                        parseState = 3;
                        continue block14;
                    }
                    if (line.startsWith("StartComposites")) {
                        parseState = 4;
                        this.compositeCharDataSection = new AfmCompositeCharDataSection();
                        continue block14;
                    }
                    this.header.addData(line);
                    this.directionSections[0].add(line);
                    continue block14;
                }
                case 2: {
                    if (line.startsWith("EndCharMetrics")) {
                        parseState = 1;
                        sectionType = 0;
                        continue block14;
                    }
                    this.charMetricsSection.add(line);
                    continue block14;
                }
                case 3: {
                    if (line.startsWith("EndKernData")) {
                        parseState = 1;
                        sectionType = 0;
                        continue block14;
                    }
                    this.kernDataSection.add(line);
                    continue block14;
                }
                case 4: {
                    if (line.startsWith("EndComposites")) {
                        parseState = 1;
                        sectionType = 0;
                        continue block14;
                    }
                    this.compositeCharDataSection.add(line);
                    continue block14;
                }
                case 5: {
                    continue block14;
                }
                case 6: {
                    if (line.startsWith("EndDirection")) {
                        parseState = 1;
                        sectionType = 0;
                        continue block14;
                    }
                    switch (sectionType) {
                        case 0: {
                            this.directionSections[0].add(line);
                            continue block14;
                        }
                        case 1: {
                            this.directionSections[1].add(line);
                            continue block14;
                        }
                        case 2: {
                            this.directionSections[0].add(line);
                            this.directionSections[1].add(line);
                            continue block14;
                        }
                    }
                    throw new IllegalStateException("The Type " + sectionType + " for the Direction-section was invalid.");
                }
            }
            throw new IllegalStateException("In Parse State " + parseState + ": Encountered line " + line);
        }
    }

    public int getMetricsSets() {
        return this.header.getMetricsSets();
    }

    public AfmDirectionSection getDirectionSection(int index) {
        return this.directionSections[index];
    }

    public FontDataInputSource getInput() {
        return this.input;
    }

    public AfmHeader getHeader() {
        return this.header;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public boolean isEmbeddable() {
        return this.embeddable;
    }

    public void dispose() {
        this.input.dispose();
    }
}

