/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.protocols.urp;

import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.protocols.urp.Cache;
import com.sun.star.lib.uno.typedesc.FieldDescription;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.uno.Any;
import com.sun.star.uno.Enum;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.XInterface;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

final class Marshal {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final DataOutput output = new DataOutputStream(this.buffer);
    private final IBridge bridge;
    private final Cache objectIdCache;
    private final Cache threadIdCache;
    private final Cache typeCache;

    public Marshal(IBridge iBridge, short s) {
        this.bridge = iBridge;
        this.objectIdCache = new Cache(s);
        this.threadIdCache = new Cache(s);
        this.typeCache = new Cache(s);
    }

    public void write8Bit(int n) {
        try {
            this.output.writeByte(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write16Bit(int n) {
        try {
            this.output.writeShort(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void writeObjectId(String string) {
        try {
            if (string == null) {
                this.writeStringValue(null);
                this.write16Bit(65535);
            } else {
                boolean[] blArray = new boolean[1];
                int n = this.objectIdCache.add(blArray, string);
                this.writeStringValue(blArray[0] ? null : string);
                this.write16Bit(n);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void writeInterface(XInterface xInterface, Type type) {
        this.writeObjectId((String)this.bridge.mapInterfaceTo((Object)xInterface, type));
    }

    public void writeThreadId(ThreadId threadId) {
        try {
            byte[] byArray = threadId.getBytes();
            boolean[] blArray = new boolean[1];
            int n = this.threadIdCache.add(blArray, byArray);
            if (blArray[0]) {
                this.writeCompressedNumber(0);
            } else {
                this.writeCompressedNumber(byArray.length);
                this.writeBytes(byArray);
            }
            this.write16Bit(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void writeType(TypeDescription typeDescription) {
        try {
            TypeClass typeClass = typeDescription.getTypeClass();
            if (TypeDescription.isTypeClassSimple((TypeClass)typeClass)) {
                this.write8Bit(typeClass.getValue());
            } else {
                boolean[] blArray = new boolean[1];
                int n = this.typeCache.add(blArray, typeDescription.getTypeName());
                this.write8Bit(typeClass.getValue() | (blArray[0] ? 0 : 128));
                this.write16Bit(n);
                if (!blArray[0]) {
                    this.writeStringValue(typeDescription.getTypeName());
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void writeValue(TypeDescription typeDescription, Object object) {
        try {
            switch (typeDescription.getTypeClass().getValue()) {
                case 0: {
                    break;
                }
                case 2: {
                    this.writeBooleanValue((Boolean)object);
                    break;
                }
                case 3: {
                    this.writeByteValue((Byte)object);
                    break;
                }
                case 4: 
                case 5: {
                    this.writeShortValue((Short)object);
                    break;
                }
                case 6: 
                case 7: {
                    this.writeLongValue((Integer)object);
                    break;
                }
                case 8: 
                case 9: {
                    this.writeHyperValue((Long)object);
                    break;
                }
                case 10: {
                    this.writeFloatValue((Float)object);
                    break;
                }
                case 11: {
                    this.writeDoubleValue((Double)object);
                    break;
                }
                case 1: {
                    this.writeCharValue((Character)object);
                    break;
                }
                case 12: {
                    this.writeStringValue((String)object);
                    break;
                }
                case 13: {
                    this.writeTypeValue((Type)object);
                    break;
                }
                case 14: {
                    this.writeAnyValue(object);
                    break;
                }
                case 20: {
                    this.writeSequenceValue(typeDescription, object);
                    break;
                }
                case 15: {
                    this.writeEnumValue(typeDescription, (Enum)object);
                    break;
                }
                case 17: {
                    this.writeStructValue(typeDescription, object);
                    break;
                }
                case 19: {
                    this.writeExceptionValue(typeDescription, (Exception)object);
                    break;
                }
                case 22: {
                    this.writeInterfaceValue(typeDescription, (XInterface)object);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad type descriptor " + typeDescription);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    public byte[] reset() {
        byte[] byArray = this.buffer.toByteArray();
        this.buffer.reset();
        return byArray;
    }

    private void writeBooleanValue(Boolean bl) throws IOException {
        this.output.writeBoolean(bl != null && bl != false);
    }

    private void writeByteValue(Byte by) {
        this.write8Bit(by == null ? (byte)0 : by);
    }

    private void writeShortValue(Short s) {
        this.write16Bit(s == null ? (short)0 : s);
    }

    private void writeLongValue(Integer n) throws IOException {
        this.write32Bit(n == null ? 0 : n);
    }

    private void writeHyperValue(Long l) throws IOException {
        this.output.writeLong(l == null ? 0L : l);
    }

    private void writeFloatValue(Float f) throws IOException {
        this.output.writeFloat(f == null ? 0.0f : f.floatValue());
    }

    private void writeDoubleValue(Double d) throws IOException {
        this.output.writeDouble(d == null ? 0.0 : d);
    }

    private void writeCharValue(Character c) throws IOException {
        this.output.writeChar(c == null ? (char)'\u0000' : c.charValue());
    }

    private void writeStringValue(String string) throws IOException {
        if (string == null) {
            this.writeCompressedNumber(0);
        } else {
            byte[] byArray = string.getBytes("UTF8");
            this.writeCompressedNumber(byArray.length);
            this.writeBytes(byArray);
        }
    }

    private void writeTypeValue(Type type) throws ClassNotFoundException {
        this.writeType(TypeDescription.getTypeDescription((Type)(type == null ? Type.VOID : type)));
    }

    private void writeAnyValue(Object object) throws ClassNotFoundException {
        TypeDescription typeDescription;
        if (object == null || object instanceof XInterface) {
            typeDescription = TypeDescription.getTypeDescription(XInterface.class);
        } else if (object instanceof Any) {
            Any any = (Any)object;
            typeDescription = TypeDescription.getTypeDescription((Type)any.getType());
            object = any.getObject();
        } else {
            if (object.getClass() == Object.class) {
                throw new IllegalArgumentException("Object instance does not represent UNO value");
            }
            typeDescription = TypeDescription.getTypeDescription(object.getClass());
        }
        this.writeType(typeDescription);
        this.writeValue(typeDescription, object);
    }

    private void writeSequenceValue(TypeDescription typeDescription, Object object) throws IOException {
        if (object == null) {
            this.writeCompressedNumber(0);
        } else {
            TypeDescription typeDescription2 = typeDescription.getComponentType();
            if (typeDescription2.getTypeClass() == TypeClass.BYTE) {
                byte[] byArray = (byte[])object;
                this.writeCompressedNumber(byArray.length);
                this.writeBytes(byArray);
            } else {
                int n = Array.getLength(object);
                this.writeCompressedNumber(n);
                for (int i = 0; i < n; ++i) {
                    this.writeValue(typeDescription2, Array.get(object, i));
                }
            }
        }
    }

    private void writeEnumValue(TypeDescription typeDescription, Enum enum_) throws IllegalAccessException, IOException, InvocationTargetException, NoSuchMethodException {
        int n = enum_ == null ? ((Enum)typeDescription.getZClass().getMethod("getDefault", null).invoke(null, (Object[])null)).getValue() : enum_.getValue();
        this.write32Bit(n);
    }

    private void writeStructValue(TypeDescription typeDescription, Object object) throws IllegalAccessException {
        FieldDescription[] fieldDescriptionArray = typeDescription.getFieldDescriptions();
        for (int i = 0; i < fieldDescriptionArray.length; ++i) {
            this.writeValue(fieldDescriptionArray[i].getTypeDescription(), object == null ? null : fieldDescriptionArray[i].getField().get(object));
        }
    }

    private void writeExceptionValue(TypeDescription typeDescription, Exception exception) throws IllegalAccessException, IOException {
        this.writeStringValue(exception == null ? null : exception.getMessage());
        this.writeStructValue(typeDescription, exception);
    }

    private void writeInterfaceValue(TypeDescription typeDescription, XInterface xInterface) {
        this.writeInterface(xInterface, new Type(typeDescription));
    }

    private void write32Bit(int n) throws IOException {
        this.output.writeInt(n);
    }

    private void writeCompressedNumber(int n) throws IOException {
        if (n >= 0 && n < 255) {
            this.write8Bit(n);
        } else {
            this.write8Bit(255);
            this.write32Bit(n);
        }
    }

    private void writeBytes(byte[] byArray) throws IOException {
        this.output.write(byArray);
    }
}

