/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowInfoStructure;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cells.DataCell;
import org.jfree.layouting.renderer.model.table.cells.TableCell;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.layouting.renderer.model.table.rows.TableRow;
import org.jfree.layouting.renderer.model.table.rows.TableRowModel;
import org.jfree.layouting.renderer.process.IterateStructuralProcessStep;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class ComputeTableICMMetricsStep
extends IterateStructuralProcessStep {
    private FastStack tableStack = new FastStack();
    private TableInfoStructure currentTable;

    public void compute(LogicalPageBox logicalPageBox) {
        this.startProcessing(logicalPageBox);
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox blockRenderBox) {
        if (blockRenderBox instanceof TableRenderBox) {
            TableRenderBox tableRenderBox = (TableRenderBox)blockRenderBox;
            this.currentTable = new TableInfoStructure(tableRenderBox);
            this.tableStack.push((Object)this.currentTable);
        } else if (blockRenderBox instanceof TableSectionRenderBox) {
            TableSectionRenderBox tableSectionRenderBox = (TableSectionRenderBox)blockRenderBox;
            this.currentTable.setRowModel(tableSectionRenderBox.getRowModel());
        }
        return true;
    }

    @Override
    protected void finishBlockBox(BlockRenderBox blockRenderBox) {
        if (blockRenderBox instanceof TableRowRenderBox) {
            this.finishTableRow((TableRowRenderBox)blockRenderBox);
        } else if (blockRenderBox instanceof TableRenderBox) {
            this.finishTable((TableRenderBox)blockRenderBox);
        } else if (blockRenderBox instanceof TableSectionRenderBox) {
            this.currentTable.setRowModel(null);
        }
    }

    private void finishTable(TableRenderBox tableRenderBox) {
        tableRenderBox.getColumnModel().validateSizes(tableRenderBox);
        this.tableStack.pop();
        this.currentTable = !this.tableStack.isEmpty() ? (TableInfoStructure)this.tableStack.peek() : null;
    }

    private void finishTableRow(TableRowRenderBox tableRowRenderBox) {
        TableRenderBox tableRenderBox = this.currentTable.getTable();
        TableColumnModel tableColumnModel = tableRenderBox.getColumnModel();
        TableSectionRenderBox tableSectionRenderBox = (TableSectionRenderBox)tableRowRenderBox.getParent();
        TableRowModel tableRowModel = tableSectionRenderBox.getRowModel();
        TableRowInfoStructure tableRowInfoStructure = tableRowRenderBox.getRowInfoStructure();
        int n = this.currentTable.getRowNumber();
        tableRowInfoStructure.setRowNumber(n);
        TableRow tableRow = tableRowModel.getRow(n);
        BoxDefinition boxDefinition = tableRowRenderBox.getBoxDefinition();
        RenderLength renderLength = boxDefinition.getPreferredHeight();
        ComputedLayoutProperties computedLayoutProperties = tableRowRenderBox.getComputedLayoutProperties();
        RenderLength renderLength2 = computedLayoutProperties.getComputedWidth();
        tableRow.clearSizes();
        tableRow.setPreferredSize(renderLength.resolve(renderLength2.resolve(0L)));
        int n2 = tableRowInfoStructure.getCellCount();
        for (int i = 0; i < n2; ++i) {
            TableCell tableCell = tableRowInfoStructure.getCellAt(i);
            if (!(tableCell instanceof DataCell)) continue;
            DataCell dataCell = (DataCell)tableCell;
            RenderNode renderNode = this.findCellInRow(tableRowRenderBox, dataCell.getCellRenderBox());
            if (renderNode == null) {
                throw new IllegalStateException("No such cell: " + dataCell.getCellRenderBox());
            }
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n3 = dataCell.getColSpan();
            tableColumn.updateMinimumChunkSize(n3, renderNode.getMinimumChunkWidth());
            tableColumn.updateMaxBoxSize(n3, renderNode.getMaximumBoxWidth());
            RenderLength renderLength3 = renderNode.getComputedLayoutProperties().getComputedWidth();
            if (!(renderLength3 == RenderLength.AUTO)) {
                tableColumn.updatePreferredSize(n3, renderLength3.getValue());
            }
            RenderLength renderLength4 = tableRowRenderBox.getBoxDefinition().getPreferredHeight();
            tableRow.updateDefinedSize(dataCell.getRowSpan(), renderLength4.resolve(renderLength3.resolve(0L)));
        }
        this.currentTable.increaseRowNumber();
    }

    private RenderNode findCellInRow(TableRowRenderBox tableRowRenderBox, Object object) {
        for (RenderNode renderNode = tableRowRenderBox.getFirstChild(); renderNode != null; renderNode = renderNode.getNext()) {
            if (renderNode.getInstanceId() != object) continue;
            return renderNode;
        }
        return null;
    }

    public static class TableInfoStructure {
        private TableRenderBox table;
        private TableColumnModel columnModel;
        private TableRowModel rowModel;
        private int rowNumber;

        public TableInfoStructure(TableRenderBox tableRenderBox) {
            this.table = tableRenderBox;
            this.columnModel = tableRenderBox.getColumnModel();
        }

        public TableRenderBox getTable() {
            return this.table;
        }

        public TableColumnModel getColumnModel() {
            return this.columnModel;
        }

        public TableRowModel getRowModel() {
            return this.rowModel;
        }

        public void setRowModel(TableRowModel tableRowModel) {
            this.rowModel = tableRowModel;
            this.rowNumber = 0;
        }

        public int getRowNumber() {
            return this.rowNumber;
        }

        public void increaseRowNumber() {
            ++this.rowNumber;
        }
    }
}

