/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.userdefined;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;

public class ParseDateFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "PARSEDATE";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        TimeZone timeZone;
        String localeText;
        if (parameters.getParameterCount() < 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        if (parameters.getParameterCount() > 4) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        String dateString = typeRegistry.convertToText(parameters.getType(0), parameters.getValue(0));
        String pattern = typeRegistry.convertToText(parameters.getType(1), parameters.getValue(1));
        Locale locale = parameters.getParameterCount() > 2 ? (StringUtils.isEmpty((String)(localeText = typeRegistry.convertToText(parameters.getType(2), parameters.getValue(2)))) ? context.getLocalizationContext().getLocale() : this.parseLocale(localeText)) : context.getLocalizationContext().getLocale();
        if (parameters.getParameterCount() > 3) {
            String timeZoneText = typeRegistry.convertToText(parameters.getType(3), parameters.getValue(3));
            timeZone = TimeZone.getTimeZone(timeZoneText);
        } else {
            timeZone = context.getLocalizationContext().getTimeZone();
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
            sdf.setTimeZone(timeZone);
            sdf.setLenient(false);
            return new TypeValuePair(DateTimeType.DATETIME_TYPE, sdf.parse(dateString));
        }
        catch (Exception e) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
    }

    private Locale parseLocale(String s) throws EvaluationException {
        StringTokenizer strtok = new StringTokenizer(s.trim(), "_");
        if (!strtok.hasMoreElements()) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
        String language = strtok.nextToken();
        String country = "";
        if (strtok.hasMoreTokens()) {
            country = strtok.nextToken();
        }
        String variant = "";
        if (strtok.hasMoreTokens()) {
            variant = strtok.nextToken();
        }
        return new Locale(language, country, variant);
    }
}

