/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions;

import java.util.HashMap;
import java.util.Iterator;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.layouter.style.functions.content.ContentFunction;
import org.jfree.layouting.layouter.style.functions.values.StyleValueFunction;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class FunctionFactory {
    public static final String VALUE_FUNCTIONS_KEY_RANGE = "org.jfree.layouting.functions.values.";
    public static final String CONTENT_FUNCTIONS_KEY_RANGE = "org.jfree.layouting.functions.content.";
    private HashMap styleFunctions = new HashMap();
    private HashMap contentFunctions = new HashMap();
    private static FunctionFactory instance;

    public static FunctionFactory getInstance() {
        if (instance == null) {
            instance = new FunctionFactory();
            instance.registerDefault();
        }
        return instance;
    }

    private FunctionFactory() {
    }

    public void registerDefault() {
        Object object;
        String string;
        String string2;
        Object object2;
        Configuration configuration = LibLayoutBoot.getInstance().getGlobalConfig();
        Iterator iterator = configuration.findPropertyKeys(VALUE_FUNCTIONS_KEY_RANGE);
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            string2 = configuration.getConfigProperty((String)object2);
            string = ((String)object2).substring(VALUE_FUNCTIONS_KEY_RANGE.length());
            object = ObjectUtilities.loadAndInstantiate((String)string2, FunctionFactory.class, StyleValueFunction.class);
            if (!(object instanceof StyleValueFunction)) continue;
            this.styleFunctions.put(string.toLowerCase(), object);
        }
        object2 = configuration.findPropertyKeys(CONTENT_FUNCTIONS_KEY_RANGE);
        while (object2.hasNext()) {
            string2 = (String)object2.next();
            string = configuration.getConfigProperty(string2);
            object = string2.substring(CONTENT_FUNCTIONS_KEY_RANGE.length());
            Object object3 = ObjectUtilities.loadAndInstantiate((String)string, FunctionFactory.class, ContentFunction.class);
            if (!(object3 instanceof ContentFunction)) continue;
            this.contentFunctions.put(((String)object).toLowerCase(), object3);
        }
    }

    public StyleValueFunction getStyleFunction(String string) {
        StyleValueFunction styleValueFunction = (StyleValueFunction)this.styleFunctions.get(string.toLowerCase());
        if (styleValueFunction == null) {
            DebugLog.log((Object)("Unrecognized style function encountered: " + string));
        }
        return styleValueFunction;
    }

    public ContentFunction getContentFunction(String string) {
        ContentFunction contentFunction = (ContentFunction)this.contentFunctions.get(string.toLowerCase());
        if (contentFunction == null) {
            DebugLog.log((Object)("Unrecognized content function encountered: " + string));
        }
        return contentFunction;
    }
}

