/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report;

import com.sun.star.awt.XWindow;
import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XChild;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.sdb.XCompletedExecution;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.sdb.XParametersSupplier;
import com.sun.star.sdb.XQueriesSupplier;
import com.sun.star.sdb.XSingleSelectQueryComposer;
import com.sun.star.sdb.tools.XConnectionTools;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XParameters;
import com.sun.star.sdbc.XRowSet;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.libreoffice.report.DataSource;
import org.libreoffice.report.DataSourceException;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.SDBCReportData;

public class SDBCReportDataFactory
implements DataSourceFactory {
    private static final String ESCAPEPROCESSING = "EscapeProcessing";
    private static final Log LOGGER = LogFactory.getLog(SDBCReportDataFactory.class);
    public static final String COMMAND_TYPE = "command-type";
    public static final String ESCAPE_PROCESSING = "escape-processing";
    public static final String SORT_EXPRESSIONS = "sort-expressions";
    public static final String GROUP_EXPRESSIONS = "group-expressions";
    public static final String MASTER_VALUES = "master-values";
    public static final String MASTER_COLUMNS = "master-columns";
    public static final String DETAIL_COLUMNS = "detail-columns";
    public static final String UNO_FILTER = "Filter";
    private static final String APPLY_FILTER = "ApplyFilter";
    private static final String UNO_COMMAND = "Command";
    private static final String UNO_COMMAND_TYPE = "CommandType";
    private final XConnection connection;
    private final XComponentContext m_cmpCtx;
    private final Map<RowSetProperties, XRowSet> rowSetProperties = new HashMap<RowSetProperties, XRowSet>();
    private final Map<RowSetProperties, ParameterDefinition> parameterMap = new HashMap<RowSetProperties, ParameterDefinition>();
    private boolean rowSetCreated = false;

    public SDBCReportDataFactory(XComponentContext xComponentContext, XConnection xConnection) {
        this.connection = xConnection;
        this.m_cmpCtx = xComponentContext;
    }

    public XWindow getParentWindow() {
        XChild xChild = (XChild)UnoRuntime.queryInterface(XChild.class, (Object)this.connection);
        if (xChild == null) {
            return null;
        }
        XDocumentDataSource xDocumentDataSource = (XDocumentDataSource)UnoRuntime.queryInterface(XDocumentDataSource.class, (Object)xChild.getParent());
        if (xDocumentDataSource == null) {
            return null;
        }
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xDocumentDataSource.getDatabaseDocument());
        if (xModel == null) {
            return null;
        }
        XController xController = xModel.getCurrentController();
        if (xController == null) {
            return null;
        }
        XFrame xFrame = xController.getFrame();
        if (xFrame == null) {
            return null;
        }
        return xFrame.getContainerWindow();
    }

    @Override
    public DataSource queryData(String string, Map<String, Object> map) throws DataSourceException {
        try {
            if (string == null) {
                return new SDBCReportData(null);
            }
            int n = 2;
            String string2 = (String)map.get(COMMAND_TYPE);
            if (string2 != null) {
                n = "query".equals(string2) ? 1 : ("table".equals(string2) ? 0 : 2);
            }
            Boolean bl = (Boolean)map.get(ESCAPE_PROCESSING);
            String string3 = (String)map.get(UNO_FILTER);
            Integer n2 = (Integer)map.get("MaxRows");
            RowSetProperties rowSetProperties = new RowSetProperties(bl, n, string, string3, n2);
            Object[] objectArray = this.createRowSet(rowSetProperties, map);
            XRowSet xRowSet = (XRowSet)objectArray[0];
            if (string.length() != 0) {
                ParameterDefinition parameterDefinition = (ParameterDefinition)objectArray[1];
                this.fillParameter(map, xRowSet, parameterDefinition);
                this.rowSetCreated = this.rowSetCreated && (n2 == null || n2 == 0);
                XCompletedExecution xCompletedExecution = (XCompletedExecution)UnoRuntime.queryInterface(XCompletedExecution.class, (Object)xRowSet);
                if (this.rowSetCreated && xCompletedExecution != null && parameterDefinition.parameterCount > 0) {
                    XWindow xWindow = this.getParentWindow();
                    XInteractionHandler xInteractionHandler = (XInteractionHandler)UnoRuntime.queryInterface(XInteractionHandler.class, (Object)this.m_cmpCtx.getServiceManager().createInstanceWithArgumentsAndContext("com.sun.star.sdb.InteractionHandler", new Object[]{new NamedValue("Parent", (Object)xWindow)}, this.m_cmpCtx));
                    xCompletedExecution.executeWithCompletion(xInteractionHandler);
                } else {
                    xRowSet.execute();
                }
            }
            this.rowSetCreated = false;
            return new SDBCReportData(xRowSet);
        }
        catch (Exception exception) {
            this.rowSetCreated = false;
            throw new DataSourceException(exception.getMessage(), exception);
        }
    }

    private String getOrderStatement(List list) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        try {
            string = this.connection.getMetaData().getIdentifierQuoteString();
        }
        catch (SQLException sQLException) {
            LOGGER.error((Object)"ReportProcessing failed / getOrderStatement could not get quote character", (Throwable)sQLException);
            string = "";
        }
        for (int i = 0; i < n; ++i) {
            String string2;
            Object[] objectArray = (Object[])list.get(i);
            String string3 = (String)objectArray[0];
            if (!string3.startsWith(string)) {
                string3 = string + string3 + string;
            }
            if ((string3 = string3.trim()).length() <= 0) continue;
            stringBuffer.append(string3);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            if ((string2 = (String)objectArray[1]) == null || string2.equals("false")) {
                stringBuffer.append("DESC");
            }
            if (i + 1 >= n) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private XSingleSelectQueryComposer getComposer(XConnectionTools xConnectionTools, String string, int n) {
        return xConnectionTools.getComposer(n, string);
    }

    private void fillParameter(Map map, XRowSet xRowSet, ParameterDefinition parameterDefinition) throws SQLException, IllegalArgumentException {
        ArrayList arrayList = (ArrayList)map.get(MASTER_VALUES);
        if (arrayList != null && !arrayList.isEmpty()) {
            XParameters xParameters = (XParameters)UnoRuntime.queryInterface(XParameters.class, (Object)xRowSet);
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object = arrayList.get(i);
                if (object instanceof BigDecimal) {
                    object = ((BigDecimal)object).toString();
                }
                Integer n = (Integer)parameterDefinition.parameterIndex.get(i);
                xParameters.setObject(n + 1, object);
            }
        }
    }

    private final Object[] createRowSet(RowSetProperties rowSetProperties, Map<String, Object> map) throws Exception {
        ArrayList arrayList = (ArrayList)map.get(DETAIL_COLUMNS);
        if (this.rowSetProperties.containsKey(rowSetProperties) && arrayList != null && !arrayList.isEmpty()) {
            return new Object[]{this.rowSetProperties.get(rowSetProperties), this.parameterMap.get(rowSetProperties)};
        }
        this.rowSetCreated = true;
        XRowSet xRowSet = (XRowSet)UnoRuntime.queryInterface(XRowSet.class, (Object)this.m_cmpCtx.getServiceManager().createInstanceWithContext("com.sun.star.sdb.RowSet", this.m_cmpCtx));
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xRowSet);
        xPropertySet.setPropertyValue("ActiveConnection", (Object)this.connection);
        xPropertySet.setPropertyValue(ESCAPEPROCESSING, (Object)rowSetProperties.escapeProcessing);
        xPropertySet.setPropertyValue(UNO_COMMAND_TYPE, (Object)rowSetProperties.commandType);
        xPropertySet.setPropertyValue(UNO_COMMAND, (Object)rowSetProperties.command);
        if (rowSetProperties.filter != null) {
            xPropertySet.setPropertyValue(UNO_FILTER, (Object)rowSetProperties.filter);
            xPropertySet.setPropertyValue(APPLY_FILTER, (Object)(rowSetProperties.filter.length() != 0 ? 1 : 0));
        } else {
            xPropertySet.setPropertyValue(APPLY_FILTER, (Object)Boolean.FALSE);
        }
        if (rowSetProperties.maxRows != null) {
            xPropertySet.setPropertyValue("MaxRows", (Object)rowSetProperties.maxRows);
        }
        XConnectionTools xConnectionTools = (XConnectionTools)UnoRuntime.queryInterface(XConnectionTools.class, (Object)this.connection);
        this.fillOrderStatement(rowSetProperties.command, rowSetProperties.commandType, map, xConnectionTools, xPropertySet);
        ParameterDefinition parameterDefinition = this.createParameter(map, xConnectionTools, rowSetProperties, xRowSet);
        this.rowSetProperties.put(rowSetProperties, xRowSet);
        this.parameterMap.put(rowSetProperties, parameterDefinition);
        return new Object[]{xRowSet, parameterDefinition};
    }

    private ParameterDefinition createParameter(Map map, XConnectionTools xConnectionTools, RowSetProperties rowSetProperties, XRowSet xRowSet) throws SQLException, UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        ParameterDefinition parameterDefinition = new ParameterDefinition();
        XSingleSelectQueryComposer xSingleSelectQueryComposer = this.getComposer(xConnectionTools, rowSetProperties.command, rowSetProperties.commandType);
        if (xSingleSelectQueryComposer != null) {
            Object object;
            Object object2;
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xRowSet);
            if (((Boolean)xPropertySet.getPropertyValue(APPLY_FILTER)).booleanValue()) {
                xSingleSelectQueryComposer.setFilter((String)xPropertySet.getPropertyValue(UNO_FILTER));
            }
            ArrayList arrayList = (ArrayList)map.get(DETAIL_COLUMNS);
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            XParametersSupplier xParametersSupplier = (XParametersSupplier)UnoRuntime.queryInterface(XParametersSupplier.class, (Object)xSingleSelectQueryComposer);
            if (xParametersSupplier != null && (object2 = xParametersSupplier.getParameters()) != null) {
                int n = object2.getCount();
                parameterDefinition.parameterCount = n;
                if (arrayList != null) {
                    block2: for (int i = 0; i < n; ++i) {
                        try {
                            XPropertySet xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object2.getByIndex(i));
                            if (xPropertySet2 == null) continue;
                            object = (String)xPropertySet2.getPropertyValue("Name");
                            for (int j = 0; j < arrayList.size(); ++j) {
                                if (!((String)object).equals(arrayList.get(j))) continue;
                                arrayList2.add(object);
                                parameterDefinition.parameterIndex.add(i);
                                --parameterDefinition.parameterCount;
                                continue block2;
                            }
                            continue;
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            Logger.getLogger(SDBCReportDataFactory.class.getName()).log(Level.SEVERE, null, indexOutOfBoundsException);
                        }
                    }
                }
            }
            if ((object2 = (ArrayList)map.get(MASTER_VALUES)) != null && !((ArrayList)object2).isEmpty() && parameterDefinition.parameterIndex.size() != arrayList.size()) {
                String string = this.connection.getMetaData().getIdentifierQuoteString();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(xSingleSelectQueryComposer.getFilter());
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(" AND ");
                }
                int n = 1;
                object = arrayList.iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    if (!arrayList2.contains(string2)) {
                        stringBuffer.append(string);
                        stringBuffer.append(string2);
                        stringBuffer.append(string);
                        stringBuffer.append(" = :link_");
                        stringBuffer.append(n);
                        if (object.hasNext()) {
                            stringBuffer.append(" AND ");
                        }
                        parameterDefinition.parameterIndex.add(n + parameterDefinition.parameterCount - 1);
                    }
                    ++n;
                }
                xSingleSelectQueryComposer.setFilter(stringBuffer.toString());
                object = xSingleSelectQueryComposer.getQuery();
                xPropertySet.setPropertyValue(UNO_COMMAND, object);
                xPropertySet.setPropertyValue(UNO_COMMAND_TYPE, (Object)2);
            }
        }
        return parameterDefinition;
    }

    private void fillOrderStatement(String string, int n, Map map, XConnectionTools xConnectionTools, XPropertySet xPropertySet) throws SQLException, UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException, NoSuchElementException {
        StringBuffer stringBuffer = new StringBuffer(this.getOrderStatement((ArrayList)map.get(SORT_EXPRESSIONS)));
        if (stringBuffer.length() > 0 && n != 0) {
            String string2 = string;
            XSingleSelectQueryComposer xSingleSelectQueryComposer = this.getComposer(xConnectionTools, string, n);
            if (xSingleSelectQueryComposer != null) {
                string2 = xSingleSelectQueryComposer.getQuery();
                xSingleSelectQueryComposer.setQuery(string2);
                String string3 = xSingleSelectQueryComposer.getOrder();
                if (string3.length() > 0) {
                    stringBuffer.append(',');
                    stringBuffer.append(string3);
                    xSingleSelectQueryComposer.setOrder("");
                    string2 = xSingleSelectQueryComposer.getQuery();
                }
            } else if (n == 1) {
                XQueriesSupplier xQueriesSupplier = (XQueriesSupplier)UnoRuntime.queryInterface(XQueriesSupplier.class, (Object)this.connection);
                XNameAccess xNameAccess = xQueriesSupplier.getQueries();
                if (xNameAccess.hasByName(string)) {
                    XPropertySet xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xNameAccess.getByName(string));
                    Boolean bl = (Boolean)xPropertySet2.getPropertyValue(ESCAPEPROCESSING);
                    xPropertySet.setPropertyValue(ESCAPEPROCESSING, (Object)bl);
                    String string4 = (String)xPropertySet2.getPropertyValue(UNO_COMMAND);
                    string2 = "SELECT * FROM (" + string4 + ") \"__LibreOffice_report_result\"";
                }
            } else {
                string2 = "SELECT * FROM (" + string + ") \"__LibreOffice_report_result\"";
            }
            xPropertySet.setPropertyValue(UNO_COMMAND, (Object)string2);
            xPropertySet.setPropertyValue(UNO_COMMAND_TYPE, (Object)2);
        }
        xPropertySet.setPropertyValue("Order", (Object)stringBuffer.toString());
    }

    private static class ParameterDefinition {
        private int parameterCount = 0;
        private final ArrayList<Integer> parameterIndex = new ArrayList();

        private ParameterDefinition() {
        }
    }

    private static class RowSetProperties {
        final Boolean escapeProcessing;
        final int commandType;
        final Integer maxRows;
        final String command;
        final String filter;

        public RowSetProperties(Boolean bl, int n, String string, String string2, Integer n2) {
            this.escapeProcessing = bl;
            this.commandType = n;
            this.command = string;
            this.filter = string2;
            this.maxRows = n2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            RowSetProperties rowSetProperties = (RowSetProperties)object;
            if (this.escapeProcessing == null ? rowSetProperties.escapeProcessing != null : !this.escapeProcessing.equals(rowSetProperties.escapeProcessing)) {
                return false;
            }
            if (this.commandType != rowSetProperties.commandType) {
                return false;
            }
            if (this.maxRows == null ? rowSetProperties.maxRows != null : !this.maxRows.equals(rowSetProperties.maxRows)) {
                return false;
            }
            if (this.command == null ? rowSetProperties.command != null : !this.command.equals(rowSetProperties.command)) {
                return false;
            }
            return !(this.filter == null ? rowSetProperties.filter != null : !this.filter.equals(rowSetProperties.filter));
        }

        public int hashCode() {
            int n = 3;
            n = 59 * n + (this.escapeProcessing != null ? this.escapeProcessing.hashCode() : 0);
            n = 59 * n + this.commandType;
            n = 59 * n + (this.maxRows != null ? this.maxRows.hashCode() : 0);
            n = 59 * n + (this.command != null ? this.command.hashCode() : 0);
            n = 59 * n + (this.filter != null ? this.filter.hashCode() : 0);
            return n;
        }
    }
}

