/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.page;

import org.jfree.layouting.input.style.PageAreaType;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.page.PageSize;
import org.jfree.layouting.input.style.keys.page.PageStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.page.PageGridUtility;
import org.jfree.layouting.util.geom.StrictGeomUtility;

public class PhysicalPageBox
implements Cloneable {
    private PageContext pageContext;
    private long width;
    private long height;
    private long imageableX;
    private long imageableY;
    private long imageableWidth;
    private long imageableHeight;
    private long globalX;
    private long globalY;

    public PhysicalPageBox(PageContext pageContext, OutputProcessorMetaData outputProcessorMetaData, long l, long l2) {
        this.globalX = l;
        this.globalY = l2;
        this.pageContext = pageContext;
        LayoutStyle layoutStyle = pageContext.getAreaDefinition(PageAreaType.CONTENT);
        CSSValue cSSValue = layoutStyle.getValue(PageStyleKeys.SIZE);
        PageSize pageSize = PageGridUtility.lookupPageSize(cSSValue, outputProcessorMetaData);
        this.width = StrictGeomUtility.toInternalValue(pageSize.getWidth());
        this.height = StrictGeomUtility.toInternalValue(pageSize.getHeight());
        CSSValue cSSValue2 = layoutStyle.getValue(BoxStyleKeys.MARGIN_TOP);
        CSSValue cSSValue3 = layoutStyle.getValue(BoxStyleKeys.MARGIN_LEFT);
        CSSValue cSSValue4 = layoutStyle.getValue(BoxStyleKeys.MARGIN_BOTTOM);
        CSSValue cSSValue5 = layoutStyle.getValue(BoxStyleKeys.MARGIN_RIGHT);
        long l3 = PhysicalPageBox.computeWidth(cSSValue2, outputProcessorMetaData).resolve(this.width);
        long l4 = PhysicalPageBox.computeWidth(cSSValue3, outputProcessorMetaData).resolve(this.width);
        long l5 = PhysicalPageBox.computeWidth(cSSValue4, outputProcessorMetaData).resolve(this.width);
        long l6 = PhysicalPageBox.computeWidth(cSSValue5, outputProcessorMetaData).resolve(this.width);
        this.imageableX = l4;
        this.imageableY = l3;
        this.imageableWidth = Math.max(0L, this.width - l4 - l6);
        this.imageableHeight = Math.max(0L, this.height - l3 - l5);
        if (this.imageableWidth == 0L) {
            this.imageableWidth = Math.max(0L, this.width - l4);
            if (this.imageableWidth == 0L) {
                this.imageableWidth = Math.max(0L, this.width);
                if (this.imageableHeight == 0L) {
                    this.imageableWidth = StrictGeomUtility.toInternalValue(outputProcessorMetaData.getDefaultPageSize().getWidth());
                    if (this.imageableWidth <= 0L) {
                        throw new IllegalStateException("The margin-definition is invalid and would not yield a layoutable page.");
                    }
                }
            }
        }
        if (this.imageableHeight == 0L) {
            this.imageableHeight = Math.max(0L, this.height - l3);
            if (this.imageableHeight == 0L) {
                this.imageableHeight = Math.max(0L, this.height);
                if (this.imageableHeight == 0L) {
                    this.imageableHeight = StrictGeomUtility.toInternalValue(outputProcessorMetaData.getDefaultPageSize().getHeight());
                    if (this.imageableHeight <= 0L) {
                        throw new IllegalStateException("I tried everything to save you, but you ignored me.");
                    }
                }
            }
        }
    }

    private static RenderLength computeWidth(CSSValue cSSValue, OutputProcessorMetaData outputProcessorMetaData) {
        RenderLength renderLength;
        if (!(cSSValue instanceof CSSNumericValue)) {
            return RenderLength.EMPTY;
        }
        CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
        if (cSSNumericValue.getValue() > 0.0 && (renderLength = RenderLength.convertToInternal(cSSValue, null, outputProcessorMetaData)).getValue() > 0L) {
            return renderLength;
        }
        return RenderLength.EMPTY;
    }

    public long getImageableX() {
        return this.imageableX;
    }

    public long getImageableY() {
        return this.imageableY;
    }

    public long getImageableWidth() {
        return this.imageableWidth;
    }

    public long getImageableHeight() {
        return this.imageableHeight;
    }

    public long getGlobalX() {
        return this.globalX;
    }

    public void setGlobalX(long l) {
        this.globalX = l;
    }

    public long getGlobalY() {
        return this.globalY;
    }

    public void setGlobalY(long l) {
        this.globalY = l;
    }

    public long getWidth() {
        return this.width;
    }

    public long getHeight() {
        return this.height;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

