/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.border;

import org.jfree.layouting.input.style.keys.border.BorderStyle;
import org.jfree.layouting.input.style.keys.border.BorderStyleKeys;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.BorderCorner;
import org.jfree.layouting.renderer.border.BorderEdge;
import org.jfree.layouting.renderer.border.EmptyBorderCorner;
import org.jfree.layouting.renderer.border.EmptyBorderEdge;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.border.RoundedBorderCorner;
import org.jfree.layouting.renderer.border.StyledBorderEdge;

public class BorderFactory {
    public Border createBorder(LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        CSSValue cSSValue = layoutContext.getValue(BorderStyleKeys.BORDER_TOP_STYLE);
        CSSValue cSSValue2 = layoutContext.getValue(BorderStyleKeys.BORDER_TOP_WIDTH);
        CSSValue cSSValue3 = layoutContext.getValue(BorderStyleKeys.BORDER_TOP_COLOR);
        BorderEdge borderEdge = this.createEdge(cSSValue, cSSValue2, cSSValue3, layoutContext, outputProcessorMetaData);
        CSSValue cSSValue4 = layoutContext.getValue(BorderStyleKeys.BORDER_LEFT_STYLE);
        CSSValue cSSValue5 = layoutContext.getValue(BorderStyleKeys.BORDER_LEFT_WIDTH);
        CSSValue cSSValue6 = layoutContext.getValue(BorderStyleKeys.BORDER_LEFT_COLOR);
        BorderEdge borderEdge2 = this.createEdge(cSSValue4, cSSValue5, cSSValue6, layoutContext, outputProcessorMetaData);
        CSSValue cSSValue7 = layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_STYLE);
        CSSValue cSSValue8 = layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_WIDTH);
        CSSValue cSSValue9 = layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_COLOR);
        BorderEdge borderEdge3 = this.createEdge(cSSValue7, cSSValue8, cSSValue9, layoutContext, outputProcessorMetaData);
        CSSValue cSSValue10 = layoutContext.getValue(BorderStyleKeys.BORDER_RIGHT_STYLE);
        CSSValue cSSValue11 = layoutContext.getValue(BorderStyleKeys.BORDER_RIGHT_WIDTH);
        CSSValue cSSValue12 = layoutContext.getValue(BorderStyleKeys.BORDER_RIGHT_COLOR);
        BorderEdge borderEdge4 = this.createEdge(cSSValue10, cSSValue11, cSSValue12, layoutContext, outputProcessorMetaData);
        CSSValue cSSValue13 = layoutContext.getValue(BorderStyleKeys.BORDER_BREAK_STYLE);
        CSSValue cSSValue14 = layoutContext.getValue(BorderStyleKeys.BORDER_BREAK_WIDTH);
        CSSValue cSSValue15 = layoutContext.getValue(BorderStyleKeys.BORDER_BREAK_COLOR);
        BorderEdge borderEdge5 = this.createEdge(cSSValue13, cSSValue14, cSSValue15, layoutContext, outputProcessorMetaData);
        CSSValue cSSValue16 = layoutContext.getValue(BorderStyleKeys.BORDER_TOP_LEFT_RADIUS);
        CSSValue cSSValue17 = layoutContext.getValue(BorderStyleKeys.BORDER_TOP_RIGHT_RADIUS);
        CSSValue cSSValue18 = layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_LEFT_RADIUS);
        CSSValue cSSValue19 = layoutContext.getValue(BorderStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS);
        BorderCorner borderCorner = this.createCorner(cSSValue16, layoutContext, outputProcessorMetaData);
        BorderCorner borderCorner2 = this.createCorner(cSSValue17, layoutContext, outputProcessorMetaData);
        BorderCorner borderCorner3 = this.createCorner(cSSValue18, layoutContext, outputProcessorMetaData);
        BorderCorner borderCorner4 = this.createCorner(cSSValue19, layoutContext, outputProcessorMetaData);
        return new Border(borderEdge, borderEdge2, borderEdge3, borderEdge4, borderEdge5, borderCorner, borderCorner2, borderCorner3, borderCorner4);
    }

    private BorderCorner createCorner(CSSValue cSSValue, LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        if (!(cSSValue instanceof CSSValuePair)) {
            return EmptyBorderCorner.getInstance();
        }
        CSSValuePair cSSValuePair = (CSSValuePair)cSSValue;
        CSSValue cSSValue2 = cSSValuePair.getFirstValue();
        CSSValue cSSValue3 = cSSValuePair.getSecondValue();
        RenderLength renderLength = RenderLength.convertToInternal(cSSValue2, layoutContext, outputProcessorMetaData);
        RenderLength renderLength2 = RenderLength.convertToInternal(cSSValue3, layoutContext, outputProcessorMetaData);
        if (renderLength.getValue() > 0L && renderLength2.getValue() > 0L) {
            return new RoundedBorderCorner(renderLength, renderLength2);
        }
        return EmptyBorderCorner.getInstance();
    }

    private BorderEdge createEdge(CSSValue cSSValue, CSSValue cSSValue2, CSSValue cSSValue3, LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        if (!(cSSValue instanceof CSSConstant)) {
            return EmptyBorderEdge.getInstance();
        }
        if (!(cSSValue3 instanceof CSSColorValue)) {
            return EmptyBorderEdge.getInstance();
        }
        if (BorderStyle.NONE.equals(cSSValue)) {
            return EmptyBorderEdge.getInstance();
        }
        RenderLength renderLength = RenderLength.convertToInternal(cSSValue2, layoutContext, outputProcessorMetaData);
        if (renderLength.getValue() <= 0L) {
            return EmptyBorderEdge.getInstance();
        }
        return new StyledBorderEdge(cSSValue, (CSSColorValue)cSSValue3, renderLength);
    }

    public static BorderEdge merge(BorderEdge borderEdge, BorderEdge borderEdge2, long l) {
        int n;
        long l2;
        CSSValue cSSValue = borderEdge.getBorderStyle();
        if (BorderStyle.HIDDEN.equals(cSSValue)) {
            return borderEdge;
        }
        CSSValue cSSValue2 = borderEdge2.getBorderStyle();
        if (BorderStyle.HIDDEN.equals(cSSValue2)) {
            return borderEdge2;
        }
        if (BorderStyle.NONE.equals(borderEdge)) {
            return borderEdge2;
        }
        if (BorderStyle.NONE.equals(borderEdge2)) {
            return borderEdge;
        }
        long l3 = borderEdge.getWidth().resolve(l);
        if (l3 < (l2 = borderEdge2.getWidth().resolve(l))) {
            return borderEdge2;
        }
        if (l2 < l3) {
            return borderEdge;
        }
        int n2 = BorderFactory.getStylePreferrence(cSSValue);
        if (n2 > (n = BorderFactory.getStylePreferrence(cSSValue2))) {
            return borderEdge;
        }
        return borderEdge2;
    }

    private static int getStylePreferrence(CSSValue cSSValue) {
        if (BorderStyle.DOUBLE.equals(cSSValue)) {
            return 10;
        }
        if (BorderStyle.SOLID.equals(cSSValue)) {
            return 9;
        }
        if (BorderStyle.DASHED.equals(cSSValue)) {
            return 8;
        }
        if (BorderStyle.DOT_DASH.equals(cSSValue)) {
            return 7;
        }
        if (BorderStyle.DOT_DOT_DASH.equals(cSSValue)) {
            return 6;
        }
        if (BorderStyle.DOTTED.equals(cSSValue)) {
            return 5;
        }
        if (BorderStyle.RIDGE.equals(cSSValue)) {
            return 4;
        }
        if (BorderStyle.OUTSET.equals(cSSValue)) {
            return 3;
        }
        if (BorderStyle.GROOVE.equals(cSSValue)) {
            return 2;
        }
        if (BorderStyle.INSET.equals(cSSValue)) {
            return 1;
        }
        return 0;
    }
}

