/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.content;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.ChainingComponent;

public final class RecordingContentNormalizer
extends ChainingComponent
implements Normalizer {
    private static final int TYPE_START_DOCUMENT = 1;
    private static final int TYPE_START_ELEMENT = 2;
    private static final int TYPE_ADD_TEXT = 3;
    private static final int TYPE_END_ELEMENT = 4;
    private static final int TYPE_END_DOCUMENT = 5;
    private StringBuffer text = new StringBuffer();
    private int elementDepth;

    @Override
    public void startDocument() {
        throw new UnsupportedOperationException("Recoding CN cannot start documents.");
    }

    @Override
    public void startElement(String string, String string2, AttributeMap attributeMap) {
        this.addCall(new ChainingComponent.RecordedCall(2, new Object[]{string, string2, attributeMap}));
        ++this.elementDepth;
    }

    @Override
    public void addText(String string) {
        this.addCall(new ChainingComponent.RecordedCall(3, string));
        this.text.append(string);
    }

    @Override
    public void endElement() {
        --this.elementDepth;
        this.addCall(new ChainingComponent.RecordedCall(4, new Object[0]));
    }

    @Override
    public void endDocument() {
        throw new UnsupportedOperationException("Recoding CN cannot start documents.");
    }

    @Override
    protected void invoke(Object object, int n, Object object2) throws Exception {
        Normalizer normalizer = (Normalizer)object;
        switch (n) {
            case 1: {
                normalizer.startDocument();
                break;
            }
            case 2: {
                Object[] objectArray = (Object[])object2;
                normalizer.startElement((String)objectArray[0], (String)objectArray[1], (AttributeMap)objectArray[2]);
                break;
            }
            case 3: {
                normalizer.addText((String)object2);
                break;
            }
            case 4: {
                Object[] objectArray = (Object[])object2;
                normalizer.endElement();
                break;
            }
            case 5: {
                normalizer.endDocument();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid call type");
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.elementDepth = 0;
        this.text = new StringBuffer();
    }

    public int getElementDepth() {
        return this.elementDepth;
    }

    @Override
    public State saveState() {
        ChainingComponent.RecordedCall[] recordedCallArray = this.retrieveRecordedCalls();
        RecodingContentNormalizerState recodingContentNormalizerState = new RecodingContentNormalizerState(recordedCallArray, this.text.toString(), this.elementDepth);
        this.setRecordedCalls(recordedCallArray);
        return recodingContentNormalizerState;
    }

    public String getText() {
        return this.text.toString();
    }

    @Override
    public void handlePageBreak(CSSValue cSSValue, PseudoPage[] pseudoPageArray) {
    }

    @Override
    public Renderer getRenderer() {
        throw new UnsupportedOperationException();
    }

    public StyleResolver getStyleResolver() {
        throw new UnsupportedOperationException();
    }

    private static class RecodingContentNormalizerState
    implements State {
        private ChainingComponent.RecordedCall[] calls;
        private String text;
        private int elementDepth;

        private RecodingContentNormalizerState(ChainingComponent.RecordedCall[] recordedCallArray, String string, int n) {
            this.text = string;
            this.elementDepth = n;
            this.calls = (ChainingComponent.RecordedCall[])recordedCallArray.clone();
        }

        @Override
        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            RecordingContentNormalizer recordingContentNormalizer = new RecordingContentNormalizer();
            recordingContentNormalizer.setRecordedCalls(this.calls);
            recordingContentNormalizer.text.append(this.text);
            recordingContentNormalizer.elementDepth = this.elementDepth;
            return recordingContentNormalizer;
        }
    }
}

