/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions;

import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionFactory;
import org.jfree.layouting.layouter.style.functions.values.StyleValueFunction;
import org.jfree.layouting.layouter.style.values.CSSResourceValue;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class FunctionUtilities {
    private static CSSNumericType[] KNOWN_TYPES = new CSSNumericType[]{CSSNumericType.PERCENTAGE, CSSNumericType.EM, CSSNumericType.EX, CSSNumericType.CM, CSSNumericType.MM, CSSNumericType.INCH, CSSNumericType.PT, CSSNumericType.PC, CSSNumericType.DEG, CSSNumericType.PX};

    private FunctionUtilities() {
    }

    public static CSSResourceValue loadResource(LayoutProcess layoutProcess, Object object) throws FunctionEvaluationException {
        Class[] classArray = layoutProcess.getOutputMetaData().getSupportedResourceTypes();
        if (classArray.length == 0) {
            throw new FunctionEvaluationException("Failed to create URI: Resource loading failed as the output target does not support any resource types.");
        }
        return FunctionUtilities.loadResource(layoutProcess, object, classArray);
    }

    public static CSSResourceValue loadResource(LayoutProcess layoutProcess, Object object, Class[] classArray) throws FunctionEvaluationException {
        ResourceManager resourceManager = layoutProcess.getResourceManager();
        ResourceKey resourceKey = DocumentContextUtility.getBaseResource(layoutProcess.getDocumentContext());
        try {
            ResourceKey resourceKey2;
            if (object instanceof ResourceKey) {
                resourceKey2 = (ResourceKey)object;
            } else if (resourceKey == null) {
                resourceKey2 = resourceManager.createKey(object);
            } else if (object instanceof String) {
                resourceKey2 = resourceManager.deriveKey(resourceKey, (String)object);
            } else {
                throw new FunctionEvaluationException("Failed to create URI: Resource loading failed: Key not derivable");
            }
            Resource resource = resourceManager.create(resourceKey2, resourceKey, classArray);
            return new CSSResourceValue(resource);
        }
        catch (Exception exception) {
            throw new FunctionEvaluationException("Failed to create URI: Resource loading failed: " + exception.getMessage(), exception);
        }
    }

    public static CSSValue parseValue(LayoutProcess layoutProcess, String string) {
        CSSNumericValue cSSNumericValue = FunctionUtilities.convertToNumber(string);
        if (cSSNumericValue != null) {
            return cSSNumericValue;
        }
        try {
            return FunctionUtilities.loadResource(layoutProcess, string);
        }
        catch (FunctionEvaluationException functionEvaluationException) {
            return new CSSStringValue(CSSStringType.STRING, string);
        }
    }

    public static CSSNumericValue parseNumberValue(String string, String string2) throws FunctionEvaluationException {
        CSSNumericValue cSSNumericValue = FunctionUtilities.convertToNumber(string, FunctionUtilities.getUnitType(string2));
        if (cSSNumericValue != null) {
            return cSSNumericValue;
        }
        throw new FunctionEvaluationException("Unable to convert to number.");
    }

    public static CSSNumericValue parseNumberValue(String string) throws FunctionEvaluationException {
        CSSNumericValue cSSNumericValue = FunctionUtilities.convertToNumber(string);
        if (cSSNumericValue != null) {
            return cSSNumericValue;
        }
        throw new FunctionEvaluationException("Unable to convert to number.");
    }

    private static CSSNumericValue convertToNumber(String string) {
        String string2 = string.trim();
        CSSNumericType cSSNumericType = null;
        for (int i = 0; i < KNOWN_TYPES.length; ++i) {
            CSSNumericType cSSNumericType2 = KNOWN_TYPES[i];
            if (!string2.endsWith(cSSNumericType2.getType())) continue;
            cSSNumericType = cSSNumericType2;
        }
        if (cSSNumericType == null) {
            cSSNumericType = CSSNumericType.NUMBER;
        }
        String string3 = string2.substring(0, string2.length() - cSSNumericType.getType().length()).trim();
        return FunctionUtilities.convertToNumber(string3, cSSNumericType);
    }

    private static CSSNumericValue convertToNumber(String string, CSSNumericType cSSNumericType) {
        if (cSSNumericType == null) {
            cSSNumericType = CSSNumericType.NUMBER;
        }
        try {
            String string2 = string.trim();
            double d = Double.parseDouble(string2);
            return CSSNumericValue.createValue(cSSNumericType, d);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static CSSNumericType getUnitType(String string) {
        if (string == null) {
            return CSSNumericType.NUMBER;
        }
        String string2 = string.trim();
        for (int i = 0; i < KNOWN_TYPES.length; ++i) {
            CSSNumericType cSSNumericType = KNOWN_TYPES[i];
            if (!string2.equalsIgnoreCase(cSSNumericType.getType())) continue;
            return cSSNumericType;
        }
        return CSSNumericType.NUMBER;
    }

    public static String resolveString(LayoutProcess layoutProcess, LayoutElement layoutElement, CSSValue cSSValue) throws FunctionEvaluationException {
        CSSValue cSSValue2 = FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValue);
        if (cSSValue2 instanceof CSSStringValue) {
            CSSStringValue cSSStringValue = (CSSStringValue)cSSValue2;
            return cSSStringValue.getValue();
        }
        String string = cSSValue2.getCSSText();
        if (string == null) {
            throw new FunctionEvaluationException("Value " + cSSValue2 + " is invalid");
        }
        return string;
    }

    public static CSSValue resolveParameter(LayoutProcess layoutProcess, LayoutElement layoutElement, CSSValue cSSValue) throws FunctionEvaluationException {
        if (!(cSSValue instanceof CSSFunctionValue)) {
            return cSSValue;
        }
        CSSFunctionValue cSSFunctionValue = (CSSFunctionValue)cSSValue;
        StyleValueFunction styleValueFunction = FunctionFactory.getInstance().getStyleFunction(cSSFunctionValue.getFunctionName());
        if (styleValueFunction == null) {
            throw new FunctionEvaluationException("Unsupported Function: " + cSSFunctionValue);
        }
        return styleValueFunction.evaluate(layoutProcess, layoutElement, cSSFunctionValue);
    }

    public static ResourceKey createURI(String string, LayoutProcess layoutProcess) {
        try {
            DocumentContext documentContext = layoutProcess.getDocumentContext();
            ResourceKey resourceKey = DocumentContextUtility.getBaseResource(documentContext);
            ResourceManager resourceManager = layoutProcess.getResourceManager();
            if (resourceKey != null) {
                try {
                    return resourceManager.deriveKey(resourceKey, string);
                }
                catch (ResourceKeyCreationException resourceKeyCreationException) {
                    // empty catch block
                }
            }
            return resourceManager.createKey((Object)string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

