/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.reportbuilder.layout;

import com.sun.star.awt.FontDescriptor;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XLayoutConstrains;
import com.sun.star.awt.XUnitConversion;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.Property;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XNameAccess;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.report.XFixedLine;
import com.sun.star.report.XFixedText;
import com.sun.star.report.XFormattedField;
import com.sun.star.report.XGroup;
import com.sun.star.report.XGroups;
import com.sun.star.report.XImageControl;
import com.sun.star.report.XReportComponent;
import com.sun.star.report.XReportControlModel;
import com.sun.star.report.XReportDefinition;
import com.sun.star.report.XSection;
import com.sun.star.style.XStyle;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XCloneable;
import com.sun.star.util.XNumberFormatTypes;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.PropertySetHelper;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.report.IReportBuilderLayouter;
import com.sun.star.wizards.report.IReportDefinitionReadAccess;
import com.sun.star.wizards.reportbuilder.layout.DesignTemplate;
import com.sun.star.wizards.reportbuilder.layout.SectionEmptyObject;
import com.sun.star.wizards.reportbuilder.layout.SectionObject;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ReportBuilderLayouter
implements IReportBuilderLayouter {
    private IReportDefinitionReadAccess m_xReportDefinitionReadAccess;
    private final Resource m_aResource;
    private String[][] m_aSortNames;
    private int m_nLeftIndent = -1;
    private int m_nRightIndent = -1;
    private int m_nPageWidth = -1;
    private XMultiServiceFactory m_xMSF;
    private int m_aCommandType;
    private String m_sTableName;
    private String[] m_aGroupNames;
    private String[] m_aFieldNames;
    private String[] m_aFieldTitleNames;
    private int[] m_aFieldWidths;
    private int[] m_aFieldTypes;
    private DesignTemplate m_xDesignTemplate = null;
    private XFixedText m_aFixedTextHelper = null;
    private HashMap<String, Integer> m_aLabelWidthMap;

    public void dispose() {
        this.closeDesignTemplate();
        this.m_xReportDefinitionReadAccess = null;
    }

    protected ReportBuilderLayouter(IReportDefinitionReadAccess iReportDefinitionReadAccess, Resource resource) {
        this.m_xReportDefinitionReadAccess = iReportDefinitionReadAccess;
        this.m_aResource = resource;
    }

    public XReportDefinition getReportDefinition() {
        return this.m_xReportDefinitionReadAccess.getReportDefinition();
    }

    private XMultiServiceFactory getGlobalMSF() {
        return this.m_xReportDefinitionReadAccess.getGlobalMSF();
    }

    public synchronized void layout() {
        try {
            this.clearReportHeader();
            this.insertReportHeader();
            this.clearReportFooter();
            this.insertReportFooter();
            this.clearPageHeader();
            this.insertPageHeader();
            this.clearPageFooter();
            this.insertPageFooter();
            this.clearGroups();
            int n = this.insertGroups();
            this.clearDetails();
            this.insertDetailFieldTitles(n);
            this.insertDetailFields();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    private void clearGroups() {
        XGroups xGroups = this.getReportDefinition().getGroups();
        while (xGroups.hasElements()) {
            try {
                xGroups.removeByIndex(0);
            }
            catch (com.sun.star.uno.Exception exception) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
    }

    private void emptySection(XSection xSection) {
        if (xSection == null) {
            return;
        }
        while (xSection.hasElements()) {
            try {
                Object object = xSection.getByIndex(0);
                XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)object);
                xSection.remove(xShape);
            }
            catch (com.sun.star.uno.Exception exception) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
    }

    private void clearDetails() {
        XSection xSection = this.getReportDefinition().getDetail();
        this.emptySection(xSection);
    }

    protected int getLeftGroupIndent(int n) {
        int n2 = 0;
        n2 = n <= 2 ? n * 500 : 1000;
        return n2;
    }

    protected int getLeftPageIndent() {
        if (this.m_nLeftIndent < 0) {
            this.m_nLeftIndent = this.getFromPageStyles("LeftMargin", 2000);
        }
        return this.m_nLeftIndent;
    }

    protected int getRightPageIndent() {
        if (this.m_nRightIndent < 0) {
            this.m_nRightIndent = this.getFromPageStyles("RightMargin", 2000);
        }
        return this.m_nRightIndent;
    }

    private XStyle getUsedStyle(String string) {
        XStyle xStyle = null;
        XNameAccess xNameAccess = this.getReportDefinition().getStyleFamilies();
        try {
            Object object = xNameAccess.getByName(string);
            XNameAccess xNameAccess2 = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object);
            String[] stringArray = xNameAccess2.getElementNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                Object object2 = xNameAccess2.getByName(string2);
                XStyle xStyle2 = (XStyle)UnoRuntime.queryInterface(XStyle.class, (Object)object2);
                if (!xStyle2.isInUse()) continue;
                xStyle = xStyle2;
                break;
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
        }
        return xStyle;
    }

    private int getFromPageStyles(String string, int n) {
        int n2 = n;
        XStyle xStyle = this.getUsedStyle("PageStyles");
        if (xStyle != null) {
            PropertySetHelper propertySetHelper = new PropertySetHelper((Object)xStyle);
            n2 = propertySetHelper.getPropertyValueAsInteger(string, n2);
        }
        return n2;
    }

    private void setToPageStyles(String string, Object object) {
        XStyle xStyle = this.getUsedStyle("PageStyles");
        if (xStyle != null) {
            PropertySetHelper propertySetHelper = new PropertySetHelper((Object)xStyle);
            propertySetHelper.setPropertyValueDontThrow(string, object);
        }
    }

    protected int getPageWidth() {
        if (this.m_nPageWidth < 0) {
            this.m_nPageWidth = this.getFromPageStyles(PropertyNames.PROPERTY_WIDTH, 21000);
        }
        return this.m_nPageWidth;
    }

    public void insertGroupNames(String[] stringArray) {
        this.m_aGroupNames = stringArray;
    }

    public void insertSortingNames(String[][] stringArray) {
        this.m_aSortNames = stringArray;
    }

    protected void copyGroupProperties(int n) {
        if (this.getDesignTemplate() != null) {
            try {
                XGroup xGroup;
                XSection xSection;
                XGroups xGroups = this.getDesignTemplate().getGroups();
                if (n < xGroups.getCount() && (xSection = (xGroup = (XGroup)UnoRuntime.queryInterface(XGroup.class, (Object)xGroups.getByIndex(n))).getHeader()) != null) {
                    XGroups xGroups2 = this.getReportDefinition().getGroups();
                    Object object = xGroups2.getByIndex(n);
                    XGroup xGroup2 = (XGroup)UnoRuntime.queryInterface(XGroup.class, (Object)object);
                    XSection xSection2 = xGroup2.getHeader();
                    this.copyProperties(xSection, xSection2);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
    }

    private int insertGroups() {
        int n;
        XGroup xGroup;
        XGroups xGroups = this.getReportDefinition().getGroups();
        int n2 = -1;
        if (this.m_aGroupNames != null) {
            int n3 = this.getLeftPageIndent();
            int n4 = this.getMaxLabelWidth();
            int n5 = this.getPageWidth() - this.getLeftPageIndent() - this.getRightPageIndent() - this.getLeftGroupIndent(this.getCountOfGroups());
            int n6 = n5 - n4;
            xGroup = null;
            for (n = 0; n < this.m_aGroupNames.length; ++n) {
                XGroup xGroup2;
                n2 = n;
                xGroup = xGroup2 = xGroups.createGroup();
                xGroup2.setExpression(this.m_aGroupNames[n]);
                xGroup2.setHeaderOn(true);
                try {
                    int n7 = xGroups.getCount();
                    xGroups.insertByIndex(n7, (Object)xGroup2);
                    XSection xSection = xGroup2.getHeader();
                    this.copyGroupProperties(n7);
                    Rectangle rectangle = new Rectangle();
                    rectangle.X = n3 + this.getLeftGroupIndent(n);
                    SectionObject sectionObject = this.getDesignTemplate().getGroupLabel(n);
                    rectangle = this.insertLabel(xSection, this.getTitleFromFieldName(this.m_aGroupNames[n]), rectangle, n4, sectionObject);
                    String string = this.convertToFieldName(this.m_aGroupNames[n]);
                    sectionObject = this.getDesignTemplate().getGroupTextField(n);
                    rectangle = this.insertFormattedField(xSection, string, rectangle, n6, sectionObject);
                    int n8 = rectangle.Height;
                    rectangle.X = n3 + this.getLeftGroupIndent(n);
                    rectangle.Y = rectangle.Height;
                    int n9 = this.getPageWidth() - this.getRightPageIndent() - rectangle.X;
                    this.insertHorizontalLine(xSection, rectangle, n9, 250);
                    xSection.setHeight(n8 + 250);
                    continue;
                }
                catch (com.sun.star.uno.Exception exception) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
                }
            }
            if (xGroup != null) {
                this.doNotBreakInTable(xGroup);
            }
        }
        if (this.m_aSortNames != null) {
            for (String[] stringArray : this.m_aSortNames) {
                try {
                    xGroup = xGroups.createGroup();
                    xGroup.setExpression(stringArray[0]);
                    xGroup.setSortAscending(PropertyNames.ASC.equals(stringArray[1]));
                    xGroup.setHeaderOn(false);
                    n = xGroups.getCount();
                    xGroups.insertByIndex(n, (Object)xGroup);
                }
                catch (Exception exception) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
                }
            }
        }
        return n2;
    }

    public void insertFieldTitles(String[] stringArray) {
        this.m_aFieldTitleNames = stringArray;
    }

    private String getTitleFromFieldName(String string) {
        for (int i = 0; i < this.m_aFieldNames.length; ++i) {
            if (!this.m_aFieldNames[i].equals(string)) continue;
            return this.m_aFieldTitleNames[i];
        }
        return PropertyNames.EMPTY_STRING;
    }

    private int getTypeFromFieldName(String string) {
        for (int i = 0; i < this.m_aFieldNames.length; ++i) {
            if (!this.m_aFieldNames[i].equals(string)) continue;
            return this.m_aFieldTypes[i];
        }
        return 0;
    }

    private boolean listContains(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private String[] getNamesWithoutGroupNames(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return new String[0];
        }
        if (this.getCountOfGroups() == 0) {
            if (stringArray2 != null) {
                return stringArray2;
            }
            return stringArray;
        }
        int n = stringArray.length - this.getCountOfGroups();
        String[] stringArray3 = new String[n];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (this.listContains(this.m_aGroupNames, string)) continue;
            stringArray3[n2++] = stringArray2 != null ? stringArray2[i] : string;
            if (n2 == n) break;
        }
        return stringArray3;
    }

    protected int calculateFieldWidth(int n, int n2) {
        int n3 = 3000;
        if (n2 > 0) {
            n3 = (this.getPageWidth() - this.getLeftPageIndent() - this.getRightPageIndent() - n) / n2;
        }
        return n3;
    }

    protected String[] getFieldTitleNames() {
        return this.getNamesWithoutGroupNames(this.m_aFieldNames, this.m_aFieldTitleNames);
    }

    protected abstract void insertDetailFieldTitles(int var1);

    public void insertFieldNames(String[] stringArray) {
        this.m_aFieldNames = stringArray;
    }

    public void insertFieldTypes(int[] nArray) {
        this.m_aFieldTypes = nArray;
    }

    public void insertFieldWidths(int[] nArray) {
        this.m_aFieldWidths = nArray;
    }

    protected int getCountOfGroups() {
        return this.m_aGroupNames == null ? 0 : this.m_aGroupNames.length;
    }

    protected String[] getFieldNames() {
        return this.getNamesWithoutGroupNames(this.m_aFieldNames, null);
    }

    protected abstract void insertDetailFields();

    protected void copyDetailProperties() {
        if (this.getDesignTemplate() != null) {
            try {
                XSection xSection = this.getDesignTemplate().getDetail();
                if (xSection != null) {
                    XSection xSection2 = this.getReportDefinition().getDetail();
                    this.copyProperties(xSection, xSection2);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
    }

    protected Rectangle insertLabel(XSection xSection, String string, Rectangle rectangle, int n, SectionObject sectionObject) {
        if (xSection != null) {
            try {
                Object object = this.getMSFofReportDefinition().createInstance("com.sun.star.report.FixedText");
                XFixedText xFixedText = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)object);
                int n2 = 500;
                if (sectionObject != null) {
                    if (sectionObject instanceof SectionEmptyObject) {
                        float f = sectionObject.getCharWeight(100.0f);
                        if (f > 0.1f) {
                            xFixedText.setCharWeight(f);
                        }
                    } else {
                        FontDescriptor fontDescriptor = sectionObject.getFontDescriptor();
                        if (fontDescriptor != null) {
                            xFixedText.setFontDescriptor(fontDescriptor);
                            this.copyProperties(sectionObject.getParent(), xFixedText);
                        }
                        n2 = sectionObject.getHeight(500);
                    }
                }
                xFixedText.setLabel(string);
                xFixedText.setPositionX(rectangle.X);
                xFixedText.setPositionY(rectangle.Y);
                xFixedText.setWidth(n);
                rectangle.X += n;
                xFixedText.setHeight(n2);
                xSection.add((XShape)xFixedText);
            }
            catch (com.sun.star.uno.Exception exception) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
        return rectangle;
    }

    protected String convertToFieldName(String string) {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("field:[").append(string).append(']');
        return stringBuffer.toString();
    }

    private String convertFromFieldName(String string) {
        if (string.startsWith("field:[")) {
            int n = string.lastIndexOf(93);
            return string.substring(7, n).trim();
        }
        return string;
    }

    protected Rectangle insertFormattedField(XSection xSection, String string, Rectangle rectangle, int n, SectionObject sectionObject) {
        return this.insertFormattedField(xSection, string, rectangle, n, sectionObject, (short)0);
    }

    private Rectangle insertFormattedField(XSection xSection, String string, Rectangle rectangle, int n, SectionObject sectionObject, short s) {
        block14: {
            if (xSection != null) {
                try {
                    FontDescriptor fontDescriptor;
                    Object object;
                    int n2 = 500;
                    int n3 = this.getTypeFromFieldName(this.convertFromFieldName(string));
                    if (n3 == -2 || n3 == -3 || n3 == -4) {
                        object = this.getMSFofReportDefinition().createInstance("com.sun.star.report.ImageControl");
                        n2 = 4000;
                    } else {
                        object = this.getMSFofReportDefinition().createInstance("com.sun.star.report.FormattedField");
                        n2 = 500;
                        if (n3 == -1) {
                            n2 = 4000;
                        }
                    }
                    rectangle.Height = n2;
                    XReportControlModel xReportControlModel = (XReportControlModel)UnoRuntime.queryInterface(XReportControlModel.class, (Object)object);
                    if (xReportControlModel == null) break block14;
                    xReportControlModel.setDataField(string);
                    if (sectionObject != null) {
                        fontDescriptor = sectionObject.getFontDescriptor();
                        if (fontDescriptor != null) {
                            xReportControlModel.setFontDescriptor(fontDescriptor);
                            this.copyProperties(sectionObject.getParent(), xReportControlModel);
                        }
                        n2 = sectionObject.getHeight(n2);
                    }
                    xReportControlModel.setPositionX(rectangle.X);
                    xReportControlModel.setPositionY(rectangle.Y);
                    xReportControlModel.setWidth(n);
                    rectangle.X += n;
                    xReportControlModel.setHeight(n2);
                    if (n3 == -2 || n3 == -3 || n3 == -4) {
                        fontDescriptor = (XImageControl)UnoRuntime.queryInterface(XImageControl.class, (Object)xReportControlModel);
                        if (fontDescriptor != null) {
                            fontDescriptor.setScaleMode((short)1);
                        }
                    } else {
                        try {
                            xReportControlModel.setParaAdjust(s);
                        }
                        catch (UnknownPropertyException unknownPropertyException) {
                            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, unknownPropertyException);
                        }
                    }
                    if (string.equals("rpt:now()")) {
                        fontDescriptor = (XFormattedField)UnoRuntime.queryInterface(XFormattedField.class, (Object)xReportControlModel);
                        XNumberFormatsSupplier xNumberFormatsSupplier = fontDescriptor.getFormatsSupplier();
                        XNumberFormats xNumberFormats = xNumberFormatsSupplier.getNumberFormats();
                        XNumberFormatTypes xNumberFormatTypes = (XNumberFormatTypes)UnoRuntime.queryInterface(XNumberFormatTypes.class, (Object)xNumberFormats);
                        Locale locale = new Locale();
                        locale.Country = java.util.Locale.getDefault().getCountry();
                        locale.Language = java.util.Locale.getDefault().getLanguage();
                        int n4 = xNumberFormatTypes.getStandardFormat((short)2, locale);
                        fontDescriptor.setFormatKey(n4);
                    }
                    xSection.add((XShape)xReportControlModel);
                }
                catch (com.sun.star.uno.Exception exception) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
                }
            }
        }
        return rectangle;
    }

    public void setTableName(int n, String string) {
        this.m_aCommandType = n;
        this.m_sTableName = string;
        this.getReportDefinition().setCommandType(n);
        this.getReportDefinition().setCommand(string);
    }

    private XMultiServiceFactory getMSFofReportDefinition() {
        if (this.m_xMSF == null) {
            this.m_xMSF = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.getReportDefinition());
        }
        return this.m_xMSF;
    }

    private Rectangle insertHorizontalLine(XSection xSection, Rectangle rectangle, int n, int n2) {
        return this.insertLine(xSection, rectangle, n, n2, 0);
    }

    private Rectangle insertLine(XSection xSection, Rectangle rectangle, int n, int n2, int n3) {
        if (xSection != null) {
            try {
                Object object = this.getMSFofReportDefinition().createInstance("com.sun.star.report.FixedLine");
                XFixedLine xFixedLine = (XFixedLine)UnoRuntime.queryInterface(XFixedLine.class, (Object)object);
                xFixedLine.setOrientation(n3);
                xFixedLine.setLineWidth(8);
                xFixedLine.setPositionX(rectangle.X);
                xFixedLine.setPositionY(rectangle.Y);
                xFixedLine.setWidth(n);
                rectangle.X += n;
                xFixedLine.setHeight(n2);
                xSection.add((XShape)xFixedLine);
            }
            catch (com.sun.star.uno.Exception exception) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
        return rectangle;
    }

    private void clearReportHeader() {
        try {
            if (this.getReportDefinition().getReportHeaderOn()) {
                XSection xSection = this.getReportDefinition().getReportHeader();
                this.emptySection(xSection);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, noSuchElementException);
        }
    }

    private void insertReportHeader() {
        if (this.getDesignTemplate() != null) {
            if (this.getDesignTemplate().getReportHeaderOn()) {
                try {
                    XSection xSection = this.getDesignTemplate().getReportHeader();
                    if (xSection != null) {
                        this.getReportDefinition().setReportHeaderOn(true);
                        XSection xSection2 = this.getReportDefinition().getReportHeader();
                        this.copySection(xSection, xSection2);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
                }
            } else {
                this.getReportDefinition().setReportHeaderOn(false);
            }
        }
    }

    private void clearReportFooter() {
        try {
            if (this.getReportDefinition().getReportFooterOn()) {
                XSection xSection = this.getReportDefinition().getReportFooter();
                this.emptySection(xSection);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, noSuchElementException);
        }
    }

    private void insertReportFooter() {
        if (this.getDesignTemplate() != null) {
            if (this.getDesignTemplate().getReportFooterOn()) {
                try {
                    XSection xSection = this.getDesignTemplate().getReportFooter();
                    if (xSection != null) {
                        this.getReportDefinition().setReportFooterOn(true);
                        XSection xSection2 = this.getReportDefinition().getReportFooter();
                        this.copySection(xSection, xSection2);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
                }
            } else {
                this.getReportDefinition().setReportFooterOn(false);
            }
        }
    }

    private void clearPageHeader() {
        try {
            if (this.getReportDefinition().getPageHeaderOn()) {
                XSection xSection = this.getReportDefinition().getPageHeader();
                this.emptySection(xSection);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, noSuchElementException);
        }
    }

    private void clearPageFooter() {
        try {
            if (this.getReportDefinition().getPageFooterOn()) {
                XSection xSection = this.getReportDefinition().getPageFooter();
                this.emptySection(xSection);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, noSuchElementException);
        }
    }

    public void setPageOrientation(int n) {
        int n2 = this.getFromPageStyles(PropertyNames.PROPERTY_WIDTH, 0);
        int n3 = this.getFromPageStyles(PropertyNames.PROPERTY_HEIGHT, 0);
        if (30 == n) {
            this.setToPageStyles("IsLandscape", Boolean.TRUE);
            if (n2 < n3) {
                this.setToPageStyles(PropertyNames.PROPERTY_WIDTH, n3);
                this.setToPageStyles(PropertyNames.PROPERTY_HEIGHT, n2);
            }
        } else {
            this.setToPageStyles("IsLandscape", Boolean.FALSE);
            if (n3 < n2) {
                this.setToPageStyles(PropertyNames.PROPERTY_WIDTH, n3);
                this.setToPageStyles(PropertyNames.PROPERTY_HEIGHT, n2);
            }
        }
        this.m_nPageWidth = -1;
    }

    private Size getPreferredSize(String string, FontDescriptor fontDescriptor) {
        Size size = new Size(0, 0);
        try {
            Object object = this.getGlobalMSF().createInstance("com.sun.star.awt.UnoControlFixedTextModel");
            XControlModel xControlModel = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, (Object)object);
            PropertySetHelper propertySetHelper = new PropertySetHelper((Object)xControlModel);
            propertySetHelper.setPropertyValueDontThrow(PropertyNames.FONT_DESCRIPTOR, (Object)fontDescriptor);
            Object object2 = this.getGlobalMSF().createInstance("com.sun.star.awt.UnoControlFixedText");
            XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)object2);
            xWindow.setVisible(false);
            XControl xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)object2);
            xControl.setModel(xControlModel);
            com.sun.star.awt.XFixedText xFixedText = (com.sun.star.awt.XFixedText)UnoRuntime.queryInterface(com.sun.star.awt.XFixedText.class, (Object)object2);
            xFixedText.setText(string);
            XLayoutConstrains xLayoutConstrains = (XLayoutConstrains)UnoRuntime.queryInterface(XLayoutConstrains.class, (Object)object2);
            Size size2 = xLayoutConstrains.getPreferredSize();
            XWindowPeer xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.getReportDefinition().getCurrentController().getFrame().getComponentWindow());
            xControl.createPeer(null, xWindowPeer);
            XWindowPeer xWindowPeer2 = xControl.getPeer();
            XUnitConversion xUnitConversion = (XUnitConversion)UnoRuntime.queryInterface(XUnitConversion.class, (Object)xWindowPeer2);
            size = xUnitConversion.convertSizeToLogic(size2, (short)0);
            XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xFixedText);
            xComponent.dispose();
            XComponent xComponent2 = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)object);
            xComponent2.dispose();
        }
        catch (Exception exception) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
        }
        return size;
    }

    private String getTableName() {
        if (this.m_sTableName != null) {
            return this.m_sTableName;
        }
        return PropertyNames.EMPTY_STRING;
    }

    private String getUserNameFromConfiguration() {
        String string = PropertyNames.EMPTY_STRING;
        String string2 = PropertyNames.EMPTY_STRING;
        try {
            Object object = Configuration.getConfigurationRoot((XMultiServiceFactory)this.getGlobalMSF(), (String)"org.openoffice.UserProfile/Data", (boolean)false);
            string = (String)Helper.getUnoObjectbyName((Object)object, (String)"givenname");
            string2 = (String)Helper.getUnoObjectbyName((Object)object, (String)"sn");
        }
        catch (Exception exception) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
        }
        return string + PropertyNames.SPACE + string2;
    }

    private void copyProperties(Object object, Object object2) {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
        XPropertySet xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object2);
        XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
        XPropertySetInfo xPropertySetInfo2 = xPropertySet2.getPropertySetInfo();
        Property[] propertyArray = xPropertySetInfo.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            String string = propertyArray[i].Name;
            if (!xPropertySetInfo2.hasPropertyByName(string)) continue;
            try {
                Property property = xPropertySetInfo.getPropertyByName(string);
                if ((property.Attributes & 0x10) != 0) continue;
                xPropertySet2.setPropertyValue(string, xPropertySet.getPropertyValue(string));
                continue;
            }
            catch (Exception exception) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
    }

    private void copySection(XSection xSection, XSection xSection2) {
        this.copyProperties(xSection, xSection2);
        try {
            XEnumeration xEnumeration = xSection.createEnumeration();
            while (xEnumeration.hasMoreElements()) {
                XCloneable xCloneable;
                Object object = xEnumeration.nextElement();
                XReportComponent xReportComponent = (XReportComponent)UnoRuntime.queryInterface(XReportComponent.class, (Object)object);
                if (xReportComponent == null || (xCloneable = xReportComponent.createClone()) == null) continue;
                XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)xCloneable);
                this.copyProperties(xReportComponent, xCloneable);
                xSection2.add(xShape);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    private void insertPageHeader() {
        if (this.getDesignTemplate() != null) {
            if (this.getDesignTemplate().getPageHeaderOn()) {
                try {
                    XSection xSection = this.getDesignTemplate().getPageHeader();
                    if (xSection != null) {
                        this.getReportDefinition().setPageHeaderOn(true);
                        XSection xSection2 = this.getReportDefinition().getPageHeader();
                        this.copySection(xSection, xSection2);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
                }
            } else {
                this.getReportDefinition().setPageHeaderOn(false);
            }
        } else {
            if (this.getReportDefinition() == null) {
                return;
            }
            String string = this.getResource().getResText("RID_REPORT_86");
            String string2 = this.getTableName();
            String string3 = this.getResource().getResText("RID_REPORT_87");
            String string4 = this.getUserNameFromConfiguration();
            String string5 = this.getResource().getResText("RID_REPORT_88");
            try {
                this.getReportDefinition().setPageHeaderOn(true);
                XSection xSection = null;
                xSection = this.getReportDefinition().getPageHeader();
                Rectangle rectangle = new Rectangle();
                rectangle.X = this.getLeftPageIndent();
                SectionObject sectionObject = SectionEmptyObject.create();
                sectionObject.setFontToBold();
                rectangle.Y = sectionObject.getHeight(500);
                rectangle = this.insertLabel(xSection, string, rectangle, 3000, sectionObject);
                int n = this.getPageWidth() - this.getLeftPageIndent() - this.getRightPageIndent() - 3000;
                rectangle = this.insertLabel(xSection, string2, rectangle, n, sectionObject);
                rectangle.Y += sectionObject.getHeight(500) + 250;
                rectangle.X = this.getLeftPageIndent();
                rectangle = this.insertLabel(xSection, string3, rectangle, 3000, sectionObject);
                rectangle = this.insertLabel(xSection, string4, rectangle, n, sectionObject);
                rectangle.Y += sectionObject.getHeight(500);
                rectangle.X = this.getLeftPageIndent();
                rectangle = this.insertLabel(xSection, string5, rectangle, 3000, sectionObject);
                rectangle = this.insertFormattedField(xSection, "rpt:now()", rectangle, n, sectionObject);
                rectangle.Y += sectionObject.getHeight(500) + 250;
                rectangle.X = this.getLeftPageIndent();
                int n2 = this.getPageWidth() - this.getRightPageIndent() - rectangle.X;
                this.insertHorizontalLine(xSection, rectangle, n2, 250);
                rectangle.Y += 250;
                xSection.setHeight(rectangle.Y);
            }
            catch (com.sun.star.uno.Exception exception) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
    }

    private void insertPageFooter() {
        if (this.getDesignTemplate() != null) {
            if (this.getDesignTemplate().getPageFooterOn()) {
                try {
                    XSection xSection = this.getDesignTemplate().getPageFooter();
                    if (xSection != null) {
                        this.getReportDefinition().setPageFooterOn(true);
                        XSection xSection2 = this.getReportDefinition().getPageFooter();
                        this.copySection(xSection, xSection2);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
                }
            } else {
                this.getReportDefinition().setPageFooterOn(false);
            }
        } else {
            if (this.getReportDefinition() == null) {
                return;
            }
            String string = this.getResource().getResText("RID_REPORT_89");
            String string2 = "\"" + string + "\"";
            String string3 = string2.replaceAll("#page#", "\" & PageNumber() & \"");
            String string4 = string3.replaceAll("#count#", "\" & PageCount() & \"");
            String string5 = string4.replaceAll(" & \\\"\\\"", PropertyNames.EMPTY_STRING);
            String string6 = string5.replaceAll("\\\"\\\" & ", PropertyNames.EMPTY_STRING);
            int n = this.getPageWidth() - this.getLeftPageIndent() - this.getRightPageIndent();
            try {
                this.getReportDefinition().setPageFooterOn(true);
                XSection xSection = null;
                xSection = this.getReportDefinition().getPageFooter();
                Rectangle rectangle = new Rectangle();
                rectangle.X = this.getLeftPageIndent();
                int n2 = this.getPageWidth() - this.getRightPageIndent() - rectangle.X;
                this.insertHorizontalLine(xSection, rectangle, n2, 250);
                rectangle.Y += 250;
                rectangle.Y += 500;
                rectangle.X = this.getLeftPageIndent();
                rectangle = this.insertFormattedField(xSection, "rpt:" + string6, rectangle, n, null, (short)1);
                rectangle.Y += 750;
                xSection.setHeight(rectangle.Y);
            }
            catch (Exception exception) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
    }

    protected Resource getResource() {
        return this.m_aResource;
    }

    public void initializeData(IReportBuilderLayouter iReportBuilderLayouter) {
        if (iReportBuilderLayouter instanceof ReportBuilderLayouter) {
            ReportBuilderLayouter reportBuilderLayouter = (ReportBuilderLayouter)iReportBuilderLayouter;
            this.m_aCommandType = reportBuilderLayouter.m_aCommandType;
            this.m_sTableName = reportBuilderLayouter.m_sTableName;
            this.m_aGroupNames = reportBuilderLayouter.m_aGroupNames;
            this.m_aFieldNames = reportBuilderLayouter.m_aFieldNames;
            this.m_aFieldTitleNames = reportBuilderLayouter.m_aFieldTitleNames;
            this.m_aFieldWidths = reportBuilderLayouter.m_aFieldWidths;
            this.m_aFieldTypes = reportBuilderLayouter.m_aFieldTypes;
            this.m_xDesignTemplate = reportBuilderLayouter.m_xDesignTemplate;
            this.m_nPageWidth = -1;
        }
    }

    protected int getMaxLabelWidth() {
        String string;
        int n;
        int n2 = 0;
        String[] stringArray = this.m_aFieldTitleNames;
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            n2 = Math.max(n2, this.getLabelWidth(string));
        }
        for (n = 0; n < this.m_aGroupNames.length; ++n) {
            string = this.m_aGroupNames[n];
            SectionObject sectionObject = this.getDesignTemplate().getGroupLabel(n);
            FontDescriptor fontDescriptor = sectionObject.getFontDescriptor();
            n2 = Math.max(n2, this.getLabelWidth(string, fontDescriptor));
        }
        n2 = n2 == 0 ? 3000 : (n2 += 500);
        return n2;
    }

    private int getLabelWidth(String string) {
        return this.getLabelWidth(string, 0.0f, 0.0f);
    }

    private int getLabelWidth(String string, FontDescriptor fontDescriptor) {
        float f = 0.0f;
        float f2 = 0.0f;
        if (fontDescriptor != null) {
            f = fontDescriptor.Weight;
            f2 = fontDescriptor.Height;
        }
        return this.getLabelWidth(string, f, f2);
    }

    private int getLabelWidth(String string, float f, float f2) {
        StringBuffer stringBuffer;
        String string2;
        int n = 0;
        if (this.m_aLabelWidthMap == null) {
            this.m_aLabelWidthMap = new HashMap();
        }
        if (this.m_aLabelWidthMap.containsKey(string2 = (stringBuffer = new StringBuffer(40)).append(string).append(f).append(f2).toString())) {
            Integer n2;
            Integer n3 = n2 = this.m_aLabelWidthMap.get(string2);
            n = n3;
        } else {
            try {
                Object object;
                if (this.m_aFixedTextHelper == null) {
                    object = this.getMSFofReportDefinition().createInstance("com.sun.star.report.FixedText");
                    this.m_aFixedTextHelper = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)object);
                }
                this.m_aFixedTextHelper.setLabel(string);
                if (f > 0.1f) {
                    this.m_aFixedTextHelper.setCharWeight(f);
                }
                if (f2 > 0.1f) {
                    this.m_aFixedTextHelper.setCharHeight(f2);
                }
                object = this.m_aFixedTextHelper.getFontDescriptor();
                Size size = this.getPreferredSize(string, (FontDescriptor)object);
                n = size.Width;
                this.m_aLabelWidthMap.put(string2, n);
            }
            catch (com.sun.star.uno.Exception exception) {
                Logger.getLogger(ReportBuilderLayouter.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
        return n;
    }

    protected void doNotBreakInTable(Object object) {
        PropertySetHelper propertySetHelper = new PropertySetHelper(object);
        propertySetHelper.setPropertyValueDontThrow("KeepTogether", (Object)Boolean.TRUE);
    }

    protected DesignTemplate getDesignTemplate() {
        if (this.m_xDesignTemplate == null) {
            String string = this.m_xReportDefinitionReadAccess.getDefaultHeaderLayout();
            this.loadAndSetBackgroundTemplate(string);
        }
        return this.m_xDesignTemplate;
    }

    private void closeDesignTemplate() {
        if (this.m_xDesignTemplate != null) {
            this.m_xDesignTemplate.close();
            this.m_xDesignTemplate = null;
        }
    }

    public void loadAndSetBackgroundTemplate(String string) {
        this.closeDesignTemplate();
        String string2 = FileAccess.getFilename((String)string);
        if (!string2.equalsIgnoreCase("default.otr_") && !string.equals("DefaultLayoutOfHeaders")) {
            XMultiServiceFactory xMultiServiceFactory = this.getGlobalMSF();
            this.m_xDesignTemplate = DesignTemplate.create(xMultiServiceFactory, string);
        }
    }
}

