/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.logical;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.ErrorType;

public class IfNaFunction
implements Function {
    private static final Log logger = LogFactory.getLog(IfNaFunction.class);
    private static final long serialVersionUID = -7517668261071087411L;

    @Override
    public String getCanonicalName() {
        return "IFNA";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Object value = null;
        Type type = null;
        boolean nafound = false;
        try {
            type = parameters.getType(0);
            value = parameters.getValue(0);
            if (ErrorType.TYPE.equals(type) && value instanceof ErrorValue) {
                logger.warn((Object)"Passing errors around is deprecated. Throw exceptions instead.");
                ErrorValue na = (ErrorValue)value;
                if (na.getErrorCode() == 522) {
                    nafound = true;
                }
            } else if (value == null) {
                nafound = true;
            }
        }
        catch (EvaluationException e) {
            if (e.getErrorValue().getErrorCode() == 522) {
                nafound = true;
            }
            throw e;
        }
        if (!nafound) {
            return new TypeValuePair(type, value);
        }
        return new TypeValuePair(parameters.getType(1), parameters.getValue(1));
    }
}

