/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

class NativeScript
extends NativeFunction
implements Script {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_compile = 3;
    private static final int Id_exec = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private Script script;
    private int prototypeIdShift = -1;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeScript obj = new NativeScript(null);
        obj.prototypeIdShift = obj.getMaxId();
        obj.addAsPrototype(obj.prototypeIdShift + 4, cx, scope, sealed);
    }

    private NativeScript(Script script) {
        this.script = script;
    }

    @Override
    public String getClassName() {
        return "Script";
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.script != null) {
            return this.script.exec(cx, scope);
        }
        return Undefined.instance;
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        throw Context.reportRuntimeError0("msg.script.is.not.constructor");
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    public String getEncodedSource() {
        if (this.script instanceof NativeFunction) {
            return ((NativeFunction)((Object)this.script)).getEncodedSource();
        }
        return super.getEncodedSource();
    }

    @Override
    public Object exec(Context cx, Scriptable scope) throws JavaScriptException {
        return this.script == null ? Undefined.instance : this.script.exec(cx, scope);
    }

    @Override
    public int methodArity(int methodId) {
        if (0 <= this.prototypeIdShift) {
            switch (methodId - this.prototypeIdShift) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    @Override
    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (0 <= this.prototypeIdShift) {
            switch (methodId - this.prototypeIdShift) {
                case 1: {
                    String source = args.length == 0 ? "" : ScriptRuntime.toString(args[0]);
                    Script script = NativeScript.compile(cx, source);
                    NativeScript nscript = new NativeScript(script);
                    nscript.setParentScope(scope);
                    nscript.setPrototype(NativeScript.getClassPrototype(scope, "Script"));
                    return nscript;
                }
                case 2: {
                    NativeScript real = NativeScript.realThis(thisObj, f);
                    Script realScript = real.script;
                    if (realScript == null) {
                        realScript = real;
                    }
                    return cx.decompileScript(realScript, NativeScript.getTopLevelScope(scope), 0);
                }
                case 4: {
                    throw Context.reportRuntimeError1("msg.cant.call.indirect", "exec");
                }
                case 3: {
                    NativeScript real = NativeScript.realThis(thisObj, f);
                    String source = ScriptRuntime.toString(args, 0);
                    real.script = NativeScript.compile(cx, source);
                    return real;
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private static NativeScript realThis(Scriptable thisObj, IdFunction f) {
        if (!(thisObj instanceof NativeScript)) {
            throw NativeScript.incompatibleCallError(f);
        }
        return (NativeScript)thisObj;
    }

    private static Script compile(Context cx, String source) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(linep);
        if (filename == null) {
            filename = "<Script object>";
            linep[0] = 1;
        }
        return cx.compileString(source, filename, linep[0], null);
    }

    @Override
    protected String getIdName(int id) {
        if (0 <= this.prototypeIdShift) {
            switch (id - this.prototypeIdShift) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 4: {
                    return "exec";
                }
                case 3: {
                    return "compile";
                }
            }
        }
        return super.getIdName(id);
    }

    @Override
    protected int mapNameToId(String s) {
        int id;
        if (0 <= this.prototypeIdShift && (id = NativeScript.toPrototypeId(s)) != 0) {
            return this.prototypeIdShift + id;
        }
        return super.mapNameToId(s);
    }

    private static int toPrototypeId(String s) {
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 4: {
                X = "exec";
                id = 4;
                break;
            }
            case 7: {
                X = "compile";
                id = 3;
                break;
            }
            case 8: {
                X = "toString";
                id = 2;
                break;
            }
            case 11: {
                X = "constructor";
                id = 1;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

