/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;

public class NodeTransformer {
    private ObjArray loops;
    private ObjArray loopEnds;
    private boolean inFunction;
    private boolean hasFinally;
    private CompilerEnvirons compilerEnv;

    public NodeTransformer(CompilerEnvirons compilerEnv) {
        this.compilerEnv = compilerEnv;
    }

    public final void transform(ScriptOrFnNode tree) {
        this.transformCompilationUnit(tree);
        for (int i = 0; i != tree.getFunctionCount(); ++i) {
            FunctionNode fn = tree.getFunctionNode(i);
            this.transform(fn);
        }
    }

    private void transformCompilationUnit(ScriptOrFnNode tree) {
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        this.inFunction = tree.getType() == 87;
        this.hasFinally = false;
        this.transformCompilationUnit_r(tree, tree);
    }

    private void transformCompilationUnit_r(ScriptOrFnNode tree, Node parent) {
        Node node = null;
        while (true) {
            Node previous = null;
            if (node == null) {
                node = parent.getFirstChild();
            } else {
                previous = node;
                node = node.getNext();
            }
            if (node == null) break;
            int type = node.getType();
            block0 : switch (type) {
                case 110: {
                    Node child;
                    Node next;
                    Node.Jump labelNode = (Node.Jump)node;
                    String id = labelNode.getLabel();
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        String otherId;
                        Node n = (Node)this.loops.get(i);
                        if (n.getType() != 110 || !id.equals(otherId = ((Node.Jump)n).getLabel())) continue;
                        this.reportError(Context.getMessage1("msg.dup.label", id), node, tree);
                        break block0;
                    }
                    Node.Target breakTarget = new Node.Target();
                    for (next = node.getNext(); next != null && (next.getType() == 110 || next.getType() == 111); next = next.getNext()) {
                    }
                    if (next == null) break;
                    parent.addChildAfter(breakTarget, next);
                    labelNode.target = breakTarget;
                    if (next.getType() == 112) {
                        labelNode.setContinue(((Node.Jump)next).getContinue());
                    } else if (next.getType() == 124 && (child = next.getFirstChild()) != null && child.getType() == 112) {
                        labelNode.setContinue(((Node.Jump)child).getContinue());
                    }
                    this.loops.push(node);
                    this.loopEnds.push(breakTarget);
                    break;
                }
                case 92: {
                    Node.Target breakTarget = new Node.Target();
                    parent.addChildAfter(breakTarget, node);
                    Node sib = node;
                    Node child = node.getFirstChild().next;
                    while (child != null) {
                        Node next = child.next;
                        node.removeChild(child);
                        parent.addChildAfter(child, sib);
                        sib = child;
                        child = next;
                    }
                    ((Node.Jump)node).target = breakTarget;
                    this.loops.push(node);
                    this.loopEnds.push(breakTarget);
                    node.putProp(8, new ObjArray());
                    break;
                }
                case 93: 
                case 94: {
                    Node sw = (Node)this.loops.peek();
                    if (type == 93) {
                        ObjArray cases = (ObjArray)sw.getProp(8);
                        cases.add(node);
                        break;
                    }
                    sw.putProp(9, node);
                    break;
                }
                case 112: {
                    this.loops.push(node);
                    this.loopEnds.push(((Node.Jump)node).target);
                    break;
                }
                case 101: {
                    if (this.inFunction) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    this.loops.push(node);
                    Node leave = node.getNext();
                    if (leave.getType() != 4) {
                        Kit.codeBug();
                    }
                    this.loopEnds.push(leave);
                    break;
                }
                case 69: {
                    Node.Jump jump = (Node.Jump)node;
                    Node.Target finallytarget = jump.getFinally();
                    if (finallytarget == null) break;
                    this.hasFinally = true;
                    this.loops.push(node);
                    this.loopEnds.push(finallytarget);
                    break;
                }
                case 4: 
                case 111: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 5: {
                    if (!this.hasFinally) break;
                    Node child = node.getFirstChild();
                    boolean inserted = false;
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node unwind;
                        Node n = (Node)this.loops.get(i);
                        int elemtype = n.getType();
                        if (elemtype != 69 && elemtype != 101) continue;
                        if (!inserted) {
                            inserted = true;
                            if (child != null) {
                                node.setType(2);
                                this.transformCompilationUnit_r(tree, node);
                                Node retPopv = new Node(67);
                                parent.addChildAfter(retPopv, node);
                                previous = node;
                                node = retPopv;
                            }
                        }
                        if (elemtype == 69) {
                            Node.Target jsrtarget;
                            Node.Jump jsrnode = new Node.Jump(115);
                            jsrnode.target = jsrtarget = ((Node.Jump)n).getFinally();
                            unwind = jsrnode;
                        } else {
                            unwind = new Node(4);
                        }
                        previous = NodeTransformer.addBeforeCurrent(parent, previous, node, unwind);
                    }
                    break;
                }
                case 98: 
                case 99: {
                    Node.Jump jump = (Node.Jump)node;
                    Node.Jump loop = null;
                    String label = jump.getLabel();
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node n = (Node)this.loops.get(i);
                        int elemtype = n.getType();
                        if (elemtype == 101) {
                            Node leave = new Node(4);
                            previous = NodeTransformer.addBeforeCurrent(parent, previous, node, leave);
                            continue;
                        }
                        if (elemtype == 69) {
                            Node.Jump tryNode = (Node.Jump)n;
                            Node.Jump jsrFinally = new Node.Jump(115);
                            jsrFinally.target = tryNode.getFinally();
                            previous = NodeTransformer.addBeforeCurrent(parent, previous, node, jsrFinally);
                            continue;
                        }
                        if (elemtype == 110) {
                            Node.Jump labelNode;
                            if (label == null || !label.equals((labelNode = (Node.Jump)n).getLabel())) continue;
                            loop = labelNode;
                            break;
                        }
                        if (elemtype == 112) {
                            if (label != null) continue;
                            loop = (Node.Jump)n;
                            break;
                        }
                        if (elemtype != 92 || label != null || type != 98) continue;
                        loop = (Node.Jump)n;
                        break;
                    }
                    Node.Target target = loop == null ? null : (type == 98 ? loop.target : loop.getContinue());
                    if (loop == null || target == null) {
                        Object messageArgs = null;
                        String msg = label == null ? Context.getMessage0(type == 99 ? "msg.continue.outside" : "msg.bad.break") : (loop != null ? Context.getMessage0("msg.continue.nonloop") : Context.getMessage1("msg.undef.label", label));
                        this.reportError(msg, node, tree);
                        break;
                    }
                    jump.setType(6);
                    jump.target = target;
                    break;
                }
                case 38: {
                    int callType = NodeTransformer.getSpecialCallType(tree, node);
                    if (callType != 0) {
                        node.putIntProp(17, callType);
                    }
                    this.visitCall(node, tree);
                    break;
                }
                case 31: {
                    int callType = NodeTransformer.getSpecialCallType(tree, node);
                    if (callType != 0) {
                        node.putIntProp(17, callType);
                    }
                    this.visitNew(node, tree);
                    break;
                }
                case 86: {
                    Node right = node.getLastChild();
                    right.setType(41);
                    break;
                }
                case 113: {
                    node.setType(this.inFunction ? 51 : 2);
                    break;
                }
                case 100: {
                    Node result = new Node(107);
                    for (Node cursor = node.getFirstChild(); cursor != null; cursor = cursor.getNext()) {
                        Node n = cursor;
                        if (n.getType() == 39) continue;
                        Kit.codeBug();
                        if (!n.hasChildren()) continue;
                        Node init = n.getFirstChild();
                        n.removeChild(init);
                        n.setType(52);
                        n = new Node(9, n, init);
                        Node pop = new Node(51, n, node.getLineno());
                        result.addChildToBack(pop);
                    }
                    node = NodeTransformer.replaceCurrent(parent, previous, node, result);
                    break;
                }
                case 9: 
                case 32: {
                    Node bind;
                    if (!this.inFunction || this.inWithStatement() || (bind = node.getFirstChild()) == null || bind.getType() != 52) break;
                    String name = bind.getString();
                    if (this.isActivationNeeded(name)) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    if (!tree.hasParamOrVar(name)) break;
                    if (type == 9) {
                        node.setType(60);
                        bind.setType(41);
                        break;
                    }
                    Node n = new Node(46);
                    node = NodeTransformer.replaceCurrent(parent, previous, node, n);
                    break;
                }
                case 34: {
                    String name;
                    if (!this.inFunction) break;
                    Node n = node.getFirstChild().getNext();
                    String string = name = n == null ? "" : n.getString();
                    if (!this.isActivationNeeded(name) && (!name.equals("length") || this.compilerEnv.getLanguageVersion() != 120)) break;
                    ((FunctionNode)tree).setRequiresActivation(true);
                    break;
                }
                case 39: {
                    if (!this.inFunction || this.inWithStatement()) break;
                    String name = node.getString();
                    if (this.isActivationNeeded(name)) {
                        ((FunctionNode)tree).setRequiresActivation(true);
                    }
                    if (!tree.hasParamOrVar(name)) break;
                    node.setType(59);
                    break;
                }
            }
            this.transformCompilationUnit_r(tree, node);
        }
    }

    protected void visitNew(Node node, ScriptOrFnNode tree) {
    }

    protected void visitCall(Node node, ScriptOrFnNode tree) {
    }

    protected boolean inWithStatement() {
        for (int i = this.loops.size() - 1; i >= 0; --i) {
            Node n = (Node)this.loops.get(i);
            if (n.getType() != 101) continue;
            return true;
        }
        return false;
    }

    private static int getSpecialCallType(Node tree, Node node) {
        String name;
        Node left = node.getFirstChild();
        int type = 0;
        if (left.getType() == 39) {
            String name2 = left.getString();
            if (name2.equals("eval")) {
                type = 1;
            } else if (name2.equals("With")) {
                type = 2;
            }
        } else if (left.getType() == 34 && (name = left.getLastChild().getString()).equals("eval")) {
            type = 1;
        }
        if (type != 0 && tree.getType() == 87) {
            ((FunctionNode)tree).setRequiresActivation(true);
        }
        return type;
    }

    private static Node addBeforeCurrent(Node parent, Node previous, Node current, Node toAdd) {
        if (previous == null) {
            if (current != parent.getFirstChild()) {
                Kit.codeBug();
            }
            parent.addChildToFront(toAdd);
        } else {
            if (current != previous.getNext()) {
                Kit.codeBug();
            }
            parent.addChildAfter(toAdd, previous);
        }
        return toAdd;
    }

    private static Node replaceCurrent(Node parent, Node previous, Node current, Node replacement) {
        if (previous == null) {
            if (current != parent.getFirstChild()) {
                Kit.codeBug();
            }
            parent.replaceChild(current, replacement);
        } else if (previous.next == current) {
            parent.replaceChildAfter(previous, replacement);
        } else {
            parent.replaceChild(current, replacement);
        }
        return replacement;
    }

    private void reportError(String message, Node stmt, ScriptOrFnNode tree) {
        int lineno = stmt.getLineno();
        String sourceName = tree.getSourceName();
        this.compilerEnv.reportSyntaxError(message, sourceName, lineno, null, 0);
    }

    private boolean isActivationNeeded(String name) {
        if ("arguments".equals(name)) {
            return true;
        }
        return this.compilerEnv.activationNames != null && this.compilerEnv.activationNames.containsKey(name);
    }
}

