/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.svek.extremity.Extremity;

class ExtremityStateLine2
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final XPoint2D dest;
    private final double radius = 5.0;
    private final double angle;

    @Override
    public XPoint2D somePoint() {
        return this.dest;
    }

    public ExtremityStateLine2(double angle, XPoint2D center) {
        this.angle = this.manageround(angle);
        this.polygon.addPoint(0.0, 0.0);
        this.dest = new XPoint2D(center.getX(), center.getY());
        int xWing = 9;
        int yAperture = 4;
        this.polygon.addPoint(-9.0, -4.0);
        int xContact = 5;
        this.polygon.addPoint(-5.0, 0.0);
        this.polygon.addPoint(-9.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(this.angle);
        this.polygon = this.polygon.translate(center.getX(), center.getY());
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(ug.getParam().getColor().bg()).apply(new UTranslate(-5.0 * Math.cos(this.angle), -5.0 * Math.sin(this.angle))).draw(this.polygon);
        ug.apply(UStroke.withThickness(1.5)).apply(HColors.WHITE.bg()).apply(new UTranslate(this.dest.getX() - 5.0, this.dest.getY() - 5.0)).draw(UEllipse.build(10.0, 10.0));
    }
}

