/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.api.ImageDataAbstract;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.eggs.PSystemWelcome;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;
import net.sourceforge.plantuml.version.IteratorCounter2;
import net.sourceforge.plantuml.version.LicenseInfo;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemError
extends AbstractPSystem {
    private final LineLocation higherErrorPosition;
    private final List<ErrorUml> printedErrors;
    private final List<String> debugLines = new ArrayList<String>();

    public PSystemError(UmlSource source, ErrorUml singleError, List<String> debugLines) {
        this(source, Collections.singletonList(singleError), debugLines);
    }

    private PSystemError(UmlSource source, List<ErrorUml> all, List<String> debugLines) {
        this.setSource(source);
        LineLocation execution = this.getHigherErrorPosition2(ErrorUmlType.EXECUTION_ERROR, all);
        LineLocation syntax = this.getHigherErrorPosition2(ErrorUmlType.SYNTAX_ERROR, all);
        if (execution == null && syntax == null) {
            throw new IllegalStateException();
        }
        if (execution != null && (syntax == null || execution.compareTo(syntax) >= 0)) {
            this.higherErrorPosition = execution;
            this.printedErrors = this.getErrorsAt2(execution, ErrorUmlType.EXECUTION_ERROR, all);
        } else {
            this.higherErrorPosition = syntax;
            this.printedErrors = this.getErrorsAt2(syntax, ErrorUmlType.SYNTAX_ERROR, all);
        }
        if (debugLines != null) {
            this.debugLines.addAll(debugLines);
        }
    }

    private String getSuggestColor(boolean useRed) {
        if (useRed) {
            return "black";
        }
        return "white";
    }

    private String getRed(boolean useRed) {
        if (useRed) {
            return "#CD0A0A";
        }
        return "red";
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        if (fileFormat.getFileFormat() == FileFormat.ATXT || fileFormat.getFileFormat() == FileFormat.UTXT) {
            UGraphicTxt ugt = new UGraphicTxt();
            UmlCharArea area = ugt.getCharArea();
            area.drawStringsLR(this.getTextStrings(), 0, 0);
            area.print(new PrintStream(os));
            return new ImageDataSimple(1, 1);
        }
        boolean useRed = fileFormat.isUseRedForError();
        IEntityImage result = GraphicStrings.createForError(this.getHtmlStrings(useRed), useRed);
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, result.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null, false);
        TextBlock udrawable = this.getSource().getTotalLineCount() < 5 ? this.addWelcome(result) : result;
        int min = (int)(System.currentTimeMillis() / 60000L) % 60;
        if (min == 1 && !LicenseInfo.retrieveNamedOrDistributorQuickIsValid()) {
            udrawable = this.addMessagePatreon(udrawable);
        } else if (min == 15 && !LicenseInfo.retrieveNamedOrDistributorQuickIsValid()) {
            udrawable = this.addMessageLiberapay(udrawable);
        } else if (min == 30 && !LicenseInfo.retrieveNamedOrDistributorQuickIsValid()) {
            udrawable = this.addMessageDedication(udrawable);
        } else if (this.getSource().containsIgnoreCase("arecibo")) {
            udrawable = this.addMessageArecibo(udrawable);
        }
        imageBuilder.setUDrawable(udrawable);
        ImageData imageData = imageBuilder.writeImageTOBEMOVED(fileFormat, this.seed(), os);
        ((ImageDataAbstract)imageData).setStatus(400);
        return imageData;
    }

    private TextBlockBackcolored getWelcome() throws IOException {
        return new PSystemWelcome(GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT).getGraphicStrings();
    }

    private TextBlock addWelcome(TextBlockBackcolored result) throws IOException {
        TextBlockBackcolored welcome = this.getWelcome();
        return TextBlockUtils.mergeTB(welcome, result, HorizontalAlignment.LEFT);
    }

    private TextBlock addMessageLiberapay(TextBlock source) throws IOException {
        TextBlockBackcolored message = this.getMessageLiberapay();
        TextBlock result = TextBlockUtils.mergeTB(message, source, HorizontalAlignment.LEFT);
        result = TextBlockUtils.mergeTB(result, message, HorizontalAlignment.LEFT);
        return result;
    }

    private TextBlock addMessagePatreon(TextBlock source) throws IOException {
        TextBlockBackcolored message = this.getMessagePatreon();
        TextBlock result = TextBlockUtils.mergeTB(message, source, HorizontalAlignment.LEFT);
        result = TextBlockUtils.mergeTB(result, message, HorizontalAlignment.LEFT);
        return result;
    }

    private TextBlock addMessageDedication(TextBlock source) throws IOException {
        TextBlockBackcolored message = this.getMessageDedication();
        TextBlock result = TextBlockUtils.mergeTB(message, source, HorizontalAlignment.LEFT);
        return result;
    }

    private TextBlock addMessageArecibo(TextBlock source) throws IOException {
        UImage message = new UImage(PSystemVersion.getArecibo());
        TextBlock result = TextBlockUtils.mergeLR(source, TextBlockUtils.fromUImage(message), VerticalAlignment.TOP);
        return result;
    }

    private TextBlockBackcolored getMessageDedication() {
        TextBlock result;
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        HtmlColorSimple backColor = (HtmlColorSimple)new HtmlColorSetSimple().getColorIfValid("#DFDCD3");
        BufferedImage qrcode = this.smaller(utils.exportFlashcode("http://plantuml.com/dedication", Color.BLACK, backColor.getColor999()));
        Display disp = Display.create("<b>Add your own dedication into PlantUML", " ", "For just $5 per month!", "Details on <i>[[http://plantuml.com/dedication]]");
        UFont font = UFont.sansSerif(14);
        FontConfiguration fc = new FontConfiguration(font, HtmlColorUtils.BLACK, HtmlColorUtils.BLACK, false);
        TextBlock text = TextBlockUtils.withMargin(disp.create(fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty()), 10.0, 0.0);
        if (qrcode == null) {
            result = text;
        } else {
            UImage qr = new UImage(qrcode).scaleNearestNeighbor(3.0);
            result = TextBlockUtils.mergeLR(text, TextBlockUtils.fromUImage(qr), VerticalAlignment.CENTER);
        }
        return TextBlockUtils.addBackcolor(result, backColor);
    }

    private TextBlockBackcolored getMessagePatreon() {
        final UImage message = new UImage(PSystemVersion.getTime01());
        Color back = new Color(message.getImage().getRGB(0, 0));
        final HtmlColorSimple backColor = new HtmlColorSimple(back, false);
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        final BufferedImage qrcode = this.smaller(utils.exportFlashcode("http://plantuml.com/patreon", Color.BLACK, Color.WHITE));
        int scale = 2;
        final double imWidth = message.getWidth() + (double)(qrcode == null ? 0 : qrcode.getWidth() * 2 + 20);
        final double imHeight = qrcode == null ? message.getHeight() : Math.max(message.getHeight(), (double)(qrcode.getHeight() * 2 + 10));
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                if (qrcode == null) {
                    ug.apply(new UTranslate(1.0, 1.0)).draw(message);
                } else {
                    UImage qr = new UImage(qrcode).scaleNearestNeighbor(2.0);
                    ug.apply(new UTranslate(1.0, (imHeight - message.getHeight()) / 2.0)).draw(message);
                    ug.apply(new UTranslate(1.0 + message.getWidth(), (imHeight - qr.getHeight()) / 2.0)).draw(qr);
                }
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(imWidth + 1.0, imHeight + 1.0);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return MinMax.fromMax(imWidth + 1.0, imHeight + 1.0);
            }

            @Override
            public HtmlColor getBackcolor() {
                return backColor;
            }
        };
    }

    private TextBlockBackcolored getMessageLiberapay() {
        final UImage message = new UImage(PSystemVersion.getTime15());
        Color back = new Color(message.getImage().getRGB(0, 0));
        final HtmlColorSimple backColor = new HtmlColorSimple(back, false);
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        final BufferedImage qrcode = this.smaller(utils.exportFlashcode("http://plantuml.com/lp", Color.BLACK, Color.WHITE));
        int scale = 2;
        final double imWidth = message.getWidth() + (double)(qrcode == null ? 0 : qrcode.getWidth() * 2 + 20);
        final double imHeight = qrcode == null ? message.getHeight() : Math.max(message.getHeight(), (double)(qrcode.getHeight() * 2 + 10));
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                if (qrcode == null) {
                    ug.apply(new UTranslate(1.0, 1.0)).draw(message);
                } else {
                    UImage qr = new UImage(qrcode).scaleNearestNeighbor(2.0);
                    ug.apply(new UTranslate(1.0, (imHeight - message.getHeight()) / 2.0)).draw(message);
                    ug.apply(new UTranslate(1.0 + message.getWidth(), (imHeight - qr.getHeight()) / 2.0)).draw(qr);
                }
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(imWidth + 1.0, imHeight + 1.0);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return MinMax.fromMax(imWidth + 1.0, imHeight + 1.0);
            }

            @Override
            public HtmlColor getBackcolor() {
                return backColor;
            }
        };
    }

    private BufferedImage smaller(BufferedImage im) {
        if (im == null) {
            return null;
        }
        boolean nb = true;
        return im.getSubimage(1, 1, im.getWidth() - 2, im.getHeight() - 2);
    }

    private List<String> getTextStrings() {
        ArrayList<String> result = new ArrayList<String>(this.getStack());
        if (result.size() > 0) {
            result.add(" ");
        }
        for (String s : this.getPartialCode()) {
            result.add(s);
        }
        String errorLine = this.getSource().getLine(this.higherErrorPosition);
        String err = StringUtils.hideComparatorCharacters(errorLine);
        if (StringUtils.isNotEmpty(err)) {
            result.add(err);
        }
        StringBuilder underscore = new StringBuilder();
        for (int i = 0; i < errorLine.length(); ++i) {
            underscore.append("^");
        }
        result.add(underscore.toString());
        LinkedHashSet<String> textErrors = new LinkedHashSet<String>();
        for (ErrorUml errorUml : this.printedErrors) {
            textErrors.add(errorUml.getError());
        }
        for (String string : textErrors) {
            result.add(" " + string);
        }
        boolean first = true;
        for (String s : this.getSuggest()) {
            if (first) {
                result.add(" " + s);
            } else {
                result.add(s);
            }
            first = false;
        }
        result.addAll(this.debugLines);
        return result;
    }

    private List<String> getStack() {
        LineLocation lineLocation = this.getLineLocation();
        ArrayList<String> result = new ArrayList<String>();
        if (lineLocation != null) {
            this.append(result, lineLocation);
            while (lineLocation.getParent() != null) {
                lineLocation = lineLocation.getParent();
                this.append(result, lineLocation);
            }
        }
        return result;
    }

    public LineLocation getLineLocation() {
        for (ErrorUml err : this.printedErrors) {
            if (err.getLineLocation() == null) continue;
            return err.getLineLocation();
        }
        return null;
    }

    private void append(List<String> result, LineLocation lineLocation) {
        if (lineLocation.getDescription() != null) {
            result.add("[From " + lineLocation.getDescription() + " (line " + (lineLocation.getPosition() + 1) + ") ]");
        }
    }

    private List<String> getPartialCode() {
        ArrayList<String> result = new ArrayList<String>();
        IteratorCounter2 it = this.getSource().iterator2();
        while (it.hasNext()) {
            CharSequence2 s = (CharSequence2)it.next();
            result.add(s.toString());
            if (!s.getLocation().getDescription().equals(this.higherErrorPosition.getDescription()) || s.getLocation().compareTo(this.higherErrorPosition) < 0) continue;
            break;
        }
        int limit = 5;
        if (result.size() > 5) {
            int skip = result.size() - 5 + 1;
            String skipMessage = skip == 1 ? "... (skipping 1 line) ..." : "... (skipping " + skip + " lines) ...";
            result = new ArrayList(result.subList(skip, result.size()));
            result.add(0, skipMessage);
        }
        return result;
    }

    private List<String> getHtmlStrings(boolean useRed) {
        ArrayList<String> htmlStrings = new ArrayList<String>(this.getStack());
        if (htmlStrings.size() > 0) {
            htmlStrings.add("----");
        }
        List<String> partialCode = this.getPartialCode();
        for (String s : partialCode) {
            htmlStrings.add(StringUtils.hideComparatorCharacters(s));
        }
        if (partialCode.size() > 0) {
            int idx = htmlStrings.size() - 1;
            Iterator last = (String)htmlStrings.get(idx);
            htmlStrings.set(idx, "<w:" + this.getRed(useRed) + ">" + last + "</w>");
        }
        LinkedHashSet<String> textErrors = new LinkedHashSet<String>();
        for (ErrorUml errorUml : this.printedErrors) {
            textErrors.add(errorUml.getError());
        }
        for (String string : textErrors) {
            htmlStrings.add(" <color:" + this.getRed(useRed) + ">" + string + "</color>");
        }
        boolean first = true;
        for (String s : this.getSuggest()) {
            if (first) {
                htmlStrings.add(" <color:" + this.getSuggestColor(useRed) + "><i>" + s + "</i></color>");
            } else {
                htmlStrings.add("<color:" + this.getSuggestColor(useRed) + ">" + StringUtils.hideComparatorCharacters(s) + "</color>");
            }
            first = false;
        }
        htmlStrings.addAll(this.debugLines);
        return htmlStrings;
    }

    private List<String> getSuggest() {
        boolean suggested = false;
        for (ErrorUml er : this.printedErrors) {
            if (!er.hasSuggest()) continue;
            suggested = true;
        }
        if (!suggested) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add("Did you mean:");
        for (ErrorUml er : this.printedErrors) {
            if (!er.hasSuggest()) continue;
            result.add(er.getSuggest().getSuggestedLine());
        }
        return Collections.unmodifiableList(result);
    }

    private Collection<ErrorUml> getErrors(ErrorUmlType type, List<ErrorUml> all) {
        LinkedHashSet<ErrorUml> result = new LinkedHashSet<ErrorUml>();
        for (ErrorUml error : all) {
            if (error.getType() != type) continue;
            result.add(error);
        }
        return result;
    }

    private LineLocation getHigherErrorPosition2(ErrorUmlType type, List<ErrorUml> all) {
        LineLocation max = null;
        for (ErrorUml error : this.getErrors(type, all)) {
            if (max != null && error.getLineLocation().compareTo(max) <= 0) continue;
            max = error.getLineLocation();
        }
        return max;
    }

    private List<ErrorUml> getErrorsAt2(LineLocation position, ErrorUmlType type, List<ErrorUml> all) {
        ArrayList<ErrorUml> result = new ArrayList<ErrorUml>();
        for (ErrorUml error : this.getErrors(type, all)) {
            if (error.getLineLocation().compareTo(position) != 0 || !StringUtils.isNotEmpty(error.getError())) continue;
            result.add(error);
        }
        return result;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Error)");
    }

    public final LineLocation getHigherErrorPosition2() {
        return this.higherErrorPosition;
    }

    public final Collection<ErrorUml> getErrorsUml() {
        return Collections.unmodifiableCollection(this.printedErrors);
    }

    @Override
    public String getWarningOrError() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDescription());
        sb.append('\n');
        for (CharSequence t : this.getTitle().getDisplay()) {
            sb.append(t);
            sb.append('\n');
        }
        sb.append('\n');
        for (String s : this.getSuggest()) {
            sb.append(s);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static PSystemError merge(Collection<PSystemError> ps) {
        UmlSource source = null;
        ArrayList<ErrorUml> errors = new ArrayList<ErrorUml>();
        ArrayList<String> debugs = new ArrayList<String>();
        for (PSystemError system : ps) {
            if (system == null) continue;
            if (system.getSource() != null && source == null) {
                source = system.getSource();
            }
            errors.addAll(system.getErrorsUml());
            debugs.addAll(system.debugLines);
            if (system.debugLines.size() <= 0) continue;
            debugs.add("-");
        }
        if (source == null) {
            throw new IllegalStateException();
        }
        return new PSystemError(source, errors, debugs);
    }
}

