/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Collection;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;

public class Branch {
    private final InstructionList list;
    private final Display labelTest;
    private final Display labelPositive;
    private final Display inlabel;
    private final HtmlColor color;
    private LinkRendering inlinkRendering = LinkRendering.none();
    private Ftile ftile;
    private LinkRendering special;

    public Branch(Swimlane swimlane, Display labelPositive, Display labelTest, HtmlColor color, Display inlabel) {
        if (labelPositive == null) {
            throw new IllegalArgumentException();
        }
        if (labelTest == null) {
            throw new IllegalArgumentException();
        }
        if (inlabel == null) {
            throw new IllegalArgumentException();
        }
        this.inlabel = inlabel;
        this.list = new InstructionList(swimlane);
        this.labelTest = labelTest;
        this.labelPositive = labelPositive;
        this.color = color;
    }

    public Collection<WeldingPoint> getWeldingPoints() {
        return this.ftile.getWeldingPoints();
    }

    public void add(Instruction ins) {
        this.list.add(ins);
    }

    public boolean kill() {
        return this.list.kill();
    }

    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        return this.list.addNote(note, position, type, colors, swimlaneNote);
    }

    public final void setInlinkRendering(LinkRendering inlinkRendering) {
        if (inlinkRendering == null) {
            throw new IllegalArgumentException();
        }
        this.inlinkRendering = inlinkRendering;
    }

    public void updateFtile(FtileFactory factory) {
        this.ftile = factory.decorateOut(this.list.createFtile(factory), this.inlinkRendering);
    }

    public Collection<? extends Swimlane> getSwimlanes() {
        return this.list.getSwimlanes();
    }

    public final Display getLabelPositive() {
        LinkRendering in = this.ftile.getInLinkRendering();
        if (in != null && !Display.isNull(in.getDisplay())) {
            return in.getDisplay();
        }
        return this.labelPositive;
    }

    public final Display getLabelTest() {
        return this.labelTest;
    }

    public final Rainbow getInlinkRenderingColorAndStyle() {
        return this.inlinkRendering == null ? null : this.inlinkRendering.getRainbow();
    }

    public Display getInlabel() {
        return this.inlabel;
    }

    public final Ftile getFtile() {
        return this.ftile;
    }

    public ISkinParam skinParam() {
        return this.ftile.skinParam();
    }

    public final HtmlColor getColor() {
        return this.color;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Instruction getLast() {
        return this.list.getLast();
    }

    public boolean isOnlySingleStopOrSpot() {
        return this.list.isOnlySingleStopOrSpot();
    }

    public void setSpecial(LinkRendering link) {
        this.special = link;
    }

    public final LinkRendering getSpecial() {
        return this.special;
    }
}

