/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.SwimlanesA;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class SwimlanesB
extends SwimlanesA {
    public SwimlanesB(ISkinParam skinParam, Pragma pragma) {
        super(skinParam, pragma);
    }

    @Override
    protected void drawWhenSwimlanes(UGraphic ug, TextBlock full) {
        super.drawWhenSwimlanes(ug, full);
        double x2 = 0.0;
        StringBounder stringBounder = ug.getStringBounder();
        for (Swimlane swimlane : this.swimlanes) {
            TextBlock swTitle = this.getTitle(swimlane);
            double titleWidth = swTitle.calculateDimension(stringBounder).getWidth();
            double posTitle = x2 + (swimlane.getActualWidth() - titleWidth) / 2.0;
            swTitle.drawU(ug.apply(new UTranslate(posTitle, 0.0)));
            x2 += swimlane.getActualWidth();
        }
    }

    private TextBlock getTitle(Swimlane swimlane) {
        FontConfiguration fontConfiguration = new FontConfiguration(this.skinParam, FontParam.SWIMLANE_TITLE, null);
        LineBreakStrategy wrap = this.getWrap();
        if (wrap.isAuto()) {
            wrap = new LineBreakStrategy("" + (int)swimlane.getActualWidth());
        }
        return swimlane.getDisplay().create(fontConfiguration, HorizontalAlignment.LEFT, (ISkinSimple)this.skinParam, wrap);
    }

    private LineBreakStrategy getWrap() {
        LineBreakStrategy wrap = this.skinParam.swimlaneWrapTitleWidth();
        if (wrap == LineBreakStrategy.NONE) {
            wrap = this.skinParam.wrapWidth();
        }
        return wrap;
    }

    @Override
    protected double swimlaneActualWidth(StringBounder stringBounder, double swimlaneWidth, Swimlane swimlane) {
        double m1 = super.swimlaneActualWidth(stringBounder, swimlaneWidth, swimlane);
        if (this.getWrap().isAuto()) {
            return m1;
        }
        double titleWidth = this.getTitle(swimlane).calculateDimension(stringBounder).getWidth();
        return MathUtils.max(m1, titleWidth + 20.0);
    }

    @Override
    protected UTranslate getTitleHeightTranslate(StringBounder stringBounder) {
        double titlesHeight = 0.0;
        for (Swimlane swimlane : this.swimlanes) {
            TextBlock swTitle = this.getTitle(swimlane);
            titlesHeight = Math.max(titlesHeight, swTitle.calculateDimension(stringBounder).getHeight());
        }
        return new UTranslate(0.0, titlesHeight);
    }
}

