/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.StringTokenizer;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;

public abstract class WithLinkType {
    protected LinkType type;
    protected boolean hidden = false;
    private boolean single = false;
    private Colors colors = Colors.empty();

    public final HtmlColor getSpecificColor() {
        return this.colors.getColor(ColorType.LINE);
    }

    public final void setSpecificColor(HtmlColor specificColor) {
        this.colors = this.colors.add(ColorType.LINE, specificColor);
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public final Colors getColors() {
        return this.colors;
    }

    public final void goDashed() {
        this.type = this.type.goDashed();
    }

    public final void goDotted() {
        this.type = this.type.goDotted();
    }

    public final void goThickness(double thickness) {
        this.type = this.type.goThickness(thickness);
    }

    public final void goHidden() {
        this.hidden = true;
    }

    public abstract void goNorank();

    public final void goBold() {
        this.type = this.type.goBold();
    }

    public final void goSingle() {
        this.single = true;
    }

    public boolean isSingle() {
        return this.single;
    }

    public void applyStyle(String arrowStyle) {
        if (arrowStyle == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(arrowStyle, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equalsIgnoreCase("dashed")) {
                this.goDashed();
                continue;
            }
            if (s.equalsIgnoreCase("bold")) {
                this.goBold();
                continue;
            }
            if (s.equalsIgnoreCase("dotted")) {
                this.goDotted();
                continue;
            }
            if (s.equalsIgnoreCase("hidden")) {
                this.goHidden();
                continue;
            }
            if (s.equalsIgnoreCase("single")) {
                this.goSingle();
                continue;
            }
            if (s.equalsIgnoreCase("plain")) continue;
            if (s.equalsIgnoreCase("norank")) {
                this.goNorank();
                continue;
            }
            if (s.startsWith("thickness=")) {
                this.goThickness(Double.parseDouble(s.substring("thickness=".length())));
                continue;
            }
            HtmlColor tmp = HtmlColorSet.getInstance().getColorIfValid(s);
            this.setSpecificColor(tmp);
        }
    }

    public LinkType getType() {
        return this.type;
    }
}

