/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.VarArgs;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class RotationZoom {
    private final double angle;
    private final double zoom;

    private RotationZoom(double angle, double zoom) {
        if (zoom < 0.0) {
            throw new IllegalArgumentException();
        }
        this.angle = angle;
        this.zoom = zoom;
    }

    public RotationZoom compose(RotationZoom other) {
        return new RotationZoom(this.angle + other.angle, this.zoom * other.zoom);
    }

    public String toString() {
        return "Rotation=" + Math.toDegrees(this.angle) + " Zoom=" + this.zoom;
    }

    public static RotationZoom fromVarArgs(VarArgs varArgs) {
        double radians = Math.toRadians(varArgs.getAsDouble("rotation", 0.0));
        double scale = varArgs.getAsDouble("scale", 1.0);
        return new RotationZoom(radians, scale);
    }

    public static RotationZoom rotationInDegrees(double angle) {
        return new RotationZoom(Math.toRadians(angle), 1.0);
    }

    public static RotationZoom rotationInRadians(double angle) {
        return new RotationZoom(angle, 1.0);
    }

    public static RotationZoom zoom(double zoom) {
        return new RotationZoom(0.0, zoom);
    }

    public RotationZoom inverse() {
        return new RotationZoom(-this.angle, 1.0 / this.zoom);
    }

    public double getAngleDegree() {
        return Math.toDegrees(this.angle);
    }

    public static RotationZoom builtRotationOnYaxis(Point2D toRotate) {
        double a = Math.atan2(toRotate.getX(), toRotate.getY());
        return new RotationZoom(a, 1.0);
    }

    public Point2D.Double getPoint(double x, double y) {
        if (this.angle == 0.0) {
            return new Point2D.Double(x * this.zoom, y * this.zoom);
        }
        double x1 = Math.cos(this.angle) * x - Math.sin(this.angle) * y;
        double y1 = Math.sin(this.angle) * x + Math.cos(this.angle) * y;
        return new Point2D.Double(x1 * this.zoom, y1 * this.zoom);
    }

    public Point2D getPoint(Point2D p) {
        return this.getPoint(p.getX(), p.getY());
    }

    public UTranslate getUTranslate(UTranslate translate) {
        return new UTranslate(this.getPoint(translate.getDx(), translate.getDy()));
    }

    public static RotationZoom none() {
        return new RotationZoom(0.0, 1.0);
    }

    public boolean isNone() {
        return this.angle == 0.0 && this.zoom == 1.0;
    }

    public double applyZoom(double value) {
        return value * this.zoom;
    }

    public double applyRotation(double alpha) {
        return this.angle + alpha;
    }
}

