/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.awt.Rectangle;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.complexscripts.fonts.Positionable;
import org.apache.fop.complexscripts.fonts.Substitutable;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.FontUris;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.XMLFontMetricsReader;
import org.apache.xmlgraphics.io.Resource;
import org.xml.sax.InputSource;

public class LazyFont
extends Typeface
implements FontDescriptor,
Substitutable,
Positionable {
    private static Log log = LogFactory.getLog(LazyFont.class);
    private final FontUris fontUris;
    private final boolean useKerning;
    private final boolean useAdvanced;
    private boolean simulateStyle;
    private boolean embedAsType1;
    private final EncodingMode encodingMode;
    private final EmbeddingMode embeddingMode;
    private final String subFontName;
    private final boolean embedded;
    private final InternalResourceResolver resourceResolver;
    private boolean isMetricsLoaded;
    private Typeface realFont;
    private FontDescriptor realFontDescriptor;

    public LazyFont(EmbedFontInfo fontInfo, InternalResourceResolver resourceResolver, boolean useComplexScripts) {
        this.fontUris = fontInfo.getFontUris();
        this.useKerning = fontInfo.getKerning();
        this.useAdvanced = resourceResolver != null ? useComplexScripts : fontInfo.getAdvanced();
        this.simulateStyle = fontInfo.getSimulateStyle();
        this.embedAsType1 = fontInfo.getEmbedAsType1();
        this.encodingMode = fontInfo.getEncodingMode() != null ? fontInfo.getEncodingMode() : EncodingMode.AUTO;
        this.embeddingMode = fontInfo.getEmbeddingMode() != null ? fontInfo.getEmbeddingMode() : EmbeddingMode.AUTO;
        this.subFontName = fontInfo.getSubFontName();
        this.embedded = fontInfo.isEmbedded();
        this.resourceResolver = resourceResolver;
    }

    @Override
    public String toString() {
        StringBuffer sbuf = new StringBuffer(super.toString());
        sbuf.append('{');
        sbuf.append("metrics-url=" + this.fontUris.getMetrics());
        sbuf.append(",embed-url=" + this.fontUris.getEmbed());
        sbuf.append(",kerning=" + this.useKerning);
        sbuf.append(",advanced=" + this.useAdvanced);
        sbuf.append('}');
        return sbuf.toString();
    }

    private void load(boolean fail) {
        if (!this.isMetricsLoaded) {
            block9: {
                try {
                    if (this.fontUris.getMetrics() != null) {
                        XMLFontMetricsReader reader = null;
                        Resource in = this.resourceResolver.getResource(this.fontUris.getMetrics());
                        InputSource src = new InputSource((InputStream)in);
                        src.setSystemId(this.fontUris.getMetrics().toASCIIString());
                        reader = new XMLFontMetricsReader(src, this.resourceResolver);
                        reader.setKerningEnabled(this.useKerning);
                        reader.setAdvancedEnabled(this.useAdvanced);
                        if (this.embedded) {
                            reader.setFontEmbedURI(this.fontUris.getEmbed());
                        }
                        this.realFont = reader.getFont();
                    } else {
                        if (this.fontUris.getEmbed() == null) {
                            throw new RuntimeException("Cannot load font. No font URIs available.");
                        }
                        this.realFont = FontLoader.loadFont(this.fontUris, this.subFontName, this.embedded, this.embeddingMode, this.encodingMode, this.useKerning, this.useAdvanced, this.resourceResolver, this.simulateStyle, this.embedAsType1);
                    }
                    if (this.realFont instanceof FontDescriptor) {
                        this.realFontDescriptor = (FontDescriptor)((Object)this.realFont);
                    }
                }
                catch (RuntimeException e) {
                    String error = "Failed to read font file " + this.fontUris.getEmbed();
                    throw new RuntimeException(error, e);
                }
                catch (Exception e) {
                    String error = "Failed to read font file " + this.fontUris.getEmbed();
                    log.error(error, e);
                    if (!fail) break block9;
                    throw new RuntimeException(error, e);
                }
            }
            this.realFont.setEventListener(this.eventListener);
            this.isMetricsLoaded = true;
        }
    }

    public Typeface getRealFont() {
        this.load(false);
        return this.realFont;
    }

    @Override
    public String getEncodingName() {
        this.load(true);
        return this.realFont.getEncodingName();
    }

    @Override
    public char mapChar(char c) {
        if (!this.isMetricsLoaded) {
            this.load(true);
        }
        return this.realFont.mapChar(c);
    }

    @Override
    public boolean hadMappingOperations() {
        this.load(true);
        return this.realFont.hadMappingOperations();
    }

    @Override
    public boolean hasChar(char c) {
        if (!this.isMetricsLoaded) {
            this.load(true);
        }
        return this.realFont.hasChar(c);
    }

    @Override
    public boolean isMultiByte() {
        this.load(true);
        return this.realFont.isMultiByte();
    }

    @Override
    public URI getFontURI() {
        this.load(true);
        return this.realFont.getFontURI();
    }

    @Override
    public String getFontName() {
        this.load(true);
        return this.realFont.getFontName();
    }

    @Override
    public String getEmbedFontName() {
        this.load(true);
        return this.realFont.getEmbedFontName();
    }

    @Override
    public String getFullName() {
        this.load(true);
        return this.realFont.getFullName();
    }

    @Override
    public Set<String> getFamilyNames() {
        this.load(true);
        return this.realFont.getFamilyNames();
    }

    @Override
    public int getMaxAscent(int size) {
        this.load(true);
        return this.realFont.getMaxAscent(size);
    }

    @Override
    public int getAscender(int size) {
        this.load(true);
        return this.realFont.getAscender(size);
    }

    @Override
    public int getCapHeight(int size) {
        this.load(true);
        return this.realFont.getCapHeight(size);
    }

    @Override
    public int getDescender(int size) {
        this.load(true);
        return this.realFont.getDescender(size);
    }

    @Override
    public int getXHeight(int size) {
        this.load(true);
        return this.realFont.getXHeight(size);
    }

    @Override
    public int getUnderlinePosition(int size) {
        this.load(true);
        return this.realFont.getUnderlinePosition(size);
    }

    @Override
    public int getUnderlineThickness(int size) {
        this.load(true);
        return this.realFont.getUnderlineThickness(size);
    }

    @Override
    public int getStrikeoutPosition(int size) {
        this.load(true);
        return this.realFont.getStrikeoutPosition(size);
    }

    @Override
    public int getStrikeoutThickness(int size) {
        this.load(true);
        return this.realFont.getStrikeoutThickness(size);
    }

    @Override
    public int getWidth(int i, int size) {
        if (!this.isMetricsLoaded) {
            this.load(true);
        }
        return this.realFont.getWidth(i, size);
    }

    @Override
    public int[] getWidths() {
        this.load(true);
        return this.realFont.getWidths();
    }

    @Override
    public Rectangle getBoundingBox(int glyphIndex, int size) {
        this.load(true);
        return this.realFont.getBoundingBox(glyphIndex, size);
    }

    @Override
    public boolean hasKerningInfo() {
        this.load(true);
        return this.realFont.hasKerningInfo();
    }

    @Override
    public Map<Integer, Map<Integer, Integer>> getKerningInfo() {
        this.load(true);
        return this.realFont.getKerningInfo();
    }

    @Override
    public boolean hasFeature(int tableType, String script, String language, String feature) {
        this.load(true);
        return this.realFont.hasFeature(tableType, script, language, feature);
    }

    @Override
    public int getCapHeight() {
        this.load(true);
        return this.realFontDescriptor.getCapHeight();
    }

    @Override
    public int getDescender() {
        this.load(true);
        return this.realFontDescriptor.getDescender();
    }

    @Override
    public int getAscender() {
        this.load(true);
        return this.realFontDescriptor.getAscender();
    }

    @Override
    public int getFlags() {
        this.load(true);
        return this.realFontDescriptor.getFlags();
    }

    @Override
    public boolean isSymbolicFont() {
        this.load(true);
        return this.realFontDescriptor.isSymbolicFont();
    }

    @Override
    public int[] getFontBBox() {
        this.load(true);
        return this.realFontDescriptor.getFontBBox();
    }

    @Override
    public int getItalicAngle() {
        this.load(true);
        return this.realFontDescriptor.getItalicAngle();
    }

    @Override
    public int getStemV() {
        this.load(true);
        return this.realFontDescriptor.getStemV();
    }

    @Override
    public FontType getFontType() {
        this.load(true);
        return this.realFontDescriptor.getFontType();
    }

    @Override
    public boolean isEmbeddable() {
        this.load(true);
        return this.realFontDescriptor.isEmbeddable();
    }

    @Override
    public boolean performsSubstitution() {
        this.load(true);
        if (this.realFontDescriptor instanceof Substitutable) {
            return ((Substitutable)((Object)this.realFontDescriptor)).performsSubstitution();
        }
        return false;
    }

    @Override
    public CharSequence performSubstitution(CharSequence cs, String script, String language, List associations, boolean retainControls) {
        this.load(true);
        if (this.realFontDescriptor instanceof Substitutable) {
            return ((Substitutable)((Object)this.realFontDescriptor)).performSubstitution(cs, script, language, associations, retainControls);
        }
        return cs;
    }

    @Override
    public CharSequence reorderCombiningMarks(CharSequence cs, int[][] gpa, String script, String language, List associations) {
        if (!this.isMetricsLoaded) {
            this.load(true);
        }
        if (this.realFontDescriptor instanceof Substitutable) {
            return ((Substitutable)((Object)this.realFontDescriptor)).reorderCombiningMarks(cs, gpa, script, language, associations);
        }
        return cs;
    }

    @Override
    public boolean performsPositioning() {
        if (!this.isMetricsLoaded) {
            this.load(true);
        }
        if (this.realFontDescriptor instanceof Positionable) {
            return ((Positionable)((Object)this.realFontDescriptor)).performsPositioning();
        }
        return false;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language, int fontSize) {
        if (!this.isMetricsLoaded) {
            this.load(true);
        }
        if (this.realFontDescriptor instanceof Positionable) {
            return ((Positionable)((Object)this.realFontDescriptor)).performPositioning(cs, script, language, fontSize);
        }
        return null;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language) {
        if (!this.isMetricsLoaded) {
            this.load(true);
        }
        if (this.realFontDescriptor instanceof Positionable) {
            return ((Positionable)((Object)this.realFontDescriptor)).performPositioning(cs, script, language);
        }
        return null;
    }

    @Override
    public boolean isSubsetEmbedded() {
        this.load(true);
        if (this.realFont.isMultiByte() && this.embeddingMode == EmbeddingMode.FULL) {
            return false;
        }
        return this.realFont.isMultiByte();
    }
}

