/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.EnumSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public class CommandHideShowByVisibility
extends SingleLineCommand2<UmlDiagram> {
    private static final EnumSet<EntityPortion> PORTION_METHOD = EnumSet.of(EntityPortion.METHOD);
    private static final EnumSet<EntityPortion> PORTION_MEMBER = EnumSet.of(EntityPortion.FIELD, EntityPortion.METHOD);
    private static final EnumSet<EntityPortion> PORTION_FIELD = EnumSet.of(EntityPortion.FIELD);

    public CommandHideShowByVisibility() {
        super(CommandHideShowByVisibility.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("COMMAND", "(hide|show)"), new RegexLeaf("[%s]+"), new RegexLeaf("VISIBILITY", "((?:public|private|protected|package)?(?:[,%s]+(?:public|private|protected|package))*)"), new RegexLeaf("[%s]+"), new RegexLeaf("PORTION", "(members?|attributes?|fields?|methods?)"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(UmlDiagram classDiagram, RegexResult arg) {
        if (classDiagram instanceof ClassDiagram) {
            return this.executeArgClass((ClassDiagram)classDiagram, arg);
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgClass(ClassDiagram classDiagram, RegexResult arg) {
        Set<EntityPortion> portion = this.getEntityPortion(arg.get("PORTION", 0));
        EnumSet<VisibilityModifier> visibilities = EnumSet.noneOf(VisibilityModifier.class);
        StringTokenizer st = new StringTokenizer(StringUtils.goLowerCase(arg.get("VISIBILITY", 0)), " ,");
        while (st.hasMoreTokens()) {
            this.addVisibilities(st.nextToken(), portion, visibilities);
        }
        classDiagram.hideOrShow(visibilities, arg.get("COMMAND", 0).equalsIgnoreCase("show"));
        return CommandExecutionResult.ok();
    }

    private void addVisibilities(String token, Set<EntityPortion> portion, Set<VisibilityModifier> result) {
        if (token.equals("public") && portion.contains((Object)EntityPortion.FIELD)) {
            result.add(VisibilityModifier.PUBLIC_FIELD);
        }
        if (token.equals("public") && portion.contains((Object)EntityPortion.METHOD)) {
            result.add(VisibilityModifier.PUBLIC_METHOD);
        }
        if (token.equals("private") && portion.contains((Object)EntityPortion.FIELD)) {
            result.add(VisibilityModifier.PRIVATE_FIELD);
        }
        if (token.equals("private") && portion.contains((Object)EntityPortion.METHOD)) {
            result.add(VisibilityModifier.PRIVATE_METHOD);
        }
        if (token.equals("protected") && portion.contains((Object)EntityPortion.FIELD)) {
            result.add(VisibilityModifier.PROTECTED_FIELD);
        }
        if (token.equals("protected") && portion.contains((Object)EntityPortion.METHOD)) {
            result.add(VisibilityModifier.PROTECTED_METHOD);
        }
        if (token.equals("package") && portion.contains((Object)EntityPortion.FIELD)) {
            result.add(VisibilityModifier.PACKAGE_PRIVATE_FIELD);
        }
        if (token.equals("package") && portion.contains((Object)EntityPortion.METHOD)) {
            result.add(VisibilityModifier.PACKAGE_PRIVATE_METHOD);
        }
    }

    private Set<EntityPortion> getEntityPortion(String s) {
        String sub = StringUtils.goLowerCase(s.substring(0, 3));
        if (sub.equals("met")) {
            return PORTION_METHOD;
        }
        if (sub.equals("mem")) {
            return PORTION_MEMBER;
        }
        if (sub.equals("att") || sub.equals("fie")) {
            return PORTION_FIELD;
        }
        throw new IllegalArgumentException();
    }
}

