/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jsondiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.yaml.Highlighted;

public class TextBlockJson
extends AbstractTextBlock {
    private static final double MIN_WIDTH = 30.0;
    private static final double MIN_HEIGHT = 15.0;
    private final List<Line> lines = new ArrayList<Line>();
    private final ISkinParam skinParam;
    private double totalWidth;
    private final JsonValue root;
    private final StyleBuilder styleBuilder;
    private final SName diagramType;

    TextBlockJson(ISkinParam skinParam, JsonValue root, List<Highlighted> allHighlighteds) {
        this.styleBuilder = skinParam.getCurrentStyleBuilder();
        this.diagramType = skinParam.getUmlDiagramType() == UmlDiagramType.JSON ? SName.jsonDiagram : SName.yamlDiagram;
        this.skinParam = skinParam;
        this.root = root;
        if (root instanceof JsonObject) {
            for (JsonObject.Member member : (JsonObject)root) {
                String key = member.getName();
                String value = this.getShortString(member.getValue());
                Highlighted highlighted = this.isHighlighted(key, allHighlighteds);
                TextBlock block1 = this.getTextBlock(this.getStyleToUse(true, highlighted), key);
                TextBlock block2 = this.getTextBlock(this.getStyleToUse(false, highlighted), value);
                this.lines.add(new Line(block1, block2, highlighted));
            }
        }
        if (root instanceof JsonArray) {
            int i = 0;
            for (JsonValue value : (JsonArray)root) {
                Highlighted highlighted = this.isHighlighted("" + i, allHighlighteds);
                TextBlock block2 = this.getTextBlock(this.getStyleToUse(false, highlighted), this.getShortString(value));
                this.lines.add(new Line(block2, highlighted));
                ++i;
            }
        }
    }

    private Style getStyleToUse(boolean header, Highlighted highlighted) {
        StyleSignature signature = header && highlighted != null ? StyleSignatureBasic.of(SName.root, SName.element, this.diagramType, SName.header, SName.node, SName.highlight).withTOBECHANGED(highlighted.getStereotype()) : (highlighted != null ? StyleSignatureBasic.of(SName.root, SName.element, this.diagramType, SName.node, SName.highlight).withTOBECHANGED(highlighted.getStereotype()) : (header ? StyleSignatureBasic.of(SName.root, SName.element, this.diagramType, SName.header, SName.node) : StyleSignatureBasic.of(SName.root, SName.element, this.diagramType, SName.node)));
        return signature.getMergedStyle(this.styleBuilder);
    }

    private Highlighted isHighlighted(String key, List<Highlighted> highlighted) {
        for (Highlighted tmp : highlighted) {
            if (!tmp.isKeyHighlight(key)) continue;
            return tmp;
        }
        return null;
    }

    public int size() {
        int size = 0;
        if (this.root instanceof JsonObject) {
            for (JsonObject.Member member : (JsonObject)this.root) {
                ++size;
            }
        }
        if (this.root instanceof JsonArray) {
            for (JsonValue value : (JsonArray)this.root) {
                ++size;
            }
        }
        return size;
    }

    private String getShortString(JsonValue value) {
        if (value.isString()) {
            return value.asString();
        }
        if (value.isNull()) {
            return "<U+2400>";
        }
        if (value.isNumber()) {
            return value.toString();
        }
        if (value.isBoolean()) {
            if (value.isTrue()) {
                return "<U+2611> true";
            }
            return "<U+2610> false";
        }
        return "   ";
    }

    public List<JsonValue> children() {
        ArrayList<JsonValue> result = new ArrayList<JsonValue>();
        if (this.root instanceof JsonObject) {
            for (JsonObject.Member member : (JsonObject)this.root) {
                JsonValue value = member.getValue();
                if (value instanceof JsonObject || value instanceof JsonArray) {
                    result.add(value);
                    continue;
                }
                result.add(null);
            }
        }
        if (this.root instanceof JsonArray) {
            for (JsonValue value : (JsonArray)this.root) {
                if (value instanceof JsonObject || value instanceof JsonArray) {
                    result.add(value);
                    continue;
                }
                result.add(null);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<String> keys() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.root instanceof JsonObject) {
            for (JsonObject.Member member : (JsonObject)this.root) {
                String key = member.getName();
                result.add(key);
            }
        }
        if (this.root instanceof JsonArray) {
            int i = 0;
            for (JsonValue value : (JsonArray)this.root) {
                result.add("" + i);
                ++i;
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double width = this.getWidthColA(stringBounder) + this.getWidthColB(stringBounder);
        double height = this.getTotalHeight(stringBounder);
        return new XDimension2D(width, height);
    }

    public double getWidthColA(StringBounder stringBounder) {
        double width = 0.0;
        for (Line line : this.lines) {
            width = Math.max(width, line.b1.calculateDimension(stringBounder).getWidth());
        }
        return width;
    }

    public double getWidthColB(StringBounder stringBounder) {
        double width = 0.0;
        for (Line line : this.lines) {
            if (line.b2 == null) continue;
            width = Math.max(width, line.b2.calculateDimension(stringBounder).getWidth());
        }
        return width;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D fullDim = this.calculateDimension(stringBounder);
        double trueWidth = Math.max(fullDim.getWidth(), this.totalWidth);
        double widthColA = this.getWidthColA(stringBounder);
        double widthColB = this.getWidthColB(stringBounder);
        double y = 0.0;
        Style styleNode = StyleSignatureBasic.of(SName.root, SName.element, this.diagramType, SName.node).getMergedStyle(this.styleBuilder);
        UGraphic ugNode = styleNode.applyStrokeAndLineColor(ug, this.skinParam.getIHtmlColorSet());
        for (Line line : this.lines) {
            double heightOfRow = line.getHeightOfRow(stringBounder);
            y += heightOfRow;
        }
        if (y == 0.0) {
            y = 15.0;
        }
        if (trueWidth == 0.0) {
            trueWidth = 30.0;
        }
        double round = styleNode.value(PName.RoundCorner).asDouble();
        URectangle fullNodeRectangle = URectangle.build(trueWidth, y).rounded(round);
        HColor backColor = styleNode.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        ugNode.apply(backColor.bg()).apply(backColor).draw(fullNodeRectangle);
        Style styleSeparator = styleNode.getSignature().add(SName.separator).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        UGraphic ugSeparator = styleSeparator.applyStrokeAndLineColor(ug, this.skinParam.getIHtmlColorSet());
        y = 0.0;
        for (Line line : this.lines) {
            UGraphic ugline = ugSeparator.apply(UTranslate.dy(y));
            double heightOfRow = line.getHeightOfRow(stringBounder);
            if (line.highlighted != null) {
                URectangle back = URectangle.build(trueWidth - 2.0, heightOfRow).rounded(4.0);
                Style styleNodeHighlight = StyleSignatureBasic.of(SName.root, SName.element, this.diagramType, SName.node, SName.highlight).withTOBECHANGED(line.highlighted.getStereotype()).getMergedStyle(this.styleBuilder);
                HColor cellBackColor = styleNodeHighlight.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
                ugline.apply(cellBackColor).apply(cellBackColor.bg()).apply(new UTranslate(1.5, 0.0)).draw(back);
            }
            if (y > 0.0) {
                ugline.draw(ULine.hline(trueWidth));
            }
            HorizontalAlignment horizontalAlignment = styleNode.getHorizontalAlignment();
            horizontalAlignment.draw(ugline, line.b1, 0.0, widthColA);
            if (line.b2 != null) {
                UGraphic uglineColB = ugline.apply(UTranslate.dx(widthColA));
                horizontalAlignment.draw(uglineColB, line.b2, 0.0, widthColB);
                uglineColB.draw(ULine.vline(heightOfRow));
            }
            y += heightOfRow;
        }
        ugNode.draw(fullNodeRectangle);
    }

    private double getTotalHeight(StringBounder stringBounder) {
        double height = 0.0;
        for (Line line : this.lines) {
            height += line.getHeightOfRow(stringBounder);
        }
        if (height == 0.0) {
            return 15.0;
        }
        return height;
    }

    public double[] getAllHeights(StringBounder stringBounder) {
        double[] result = new double[this.lines.size()];
        for (int i = 0; i < this.lines.size(); ++i) {
            result[i] = this.lines.get(i).getHeightOfRow(stringBounder);
        }
        return result;
    }

    private TextBlock getTextBlock(Style style, String key) {
        Display display = Display.getWithNewlines(key);
        FontConfiguration fontConfiguration = style.getFontConfiguration(this.skinParam.getIHtmlColorSet());
        LineBreakStrategy wrap = style.wrapWidth();
        HorizontalAlignment horizontalAlignment = style.getHorizontalAlignment();
        TextBlock result = display.create0(fontConfiguration, horizontalAlignment, this.skinParam, wrap, CreoleMode.NO_CREOLE, null, null);
        result = TextBlockUtils.withMargin(result, 5.0, 2.0);
        return result;
    }

    public void setTotalWidth(double totalWidth) {
        this.totalWidth = totalWidth;
    }

    @Override
    public HColor getBackcolor() {
        return null;
    }

    static class Line {
        final TextBlock b1;
        final TextBlock b2;
        final Highlighted highlighted;

        Line(TextBlock b1, TextBlock b2, Highlighted highlighted) {
            this.b1 = b1;
            this.b2 = b2;
            this.highlighted = highlighted;
        }

        Line(TextBlock b1, Highlighted highlighted) {
            this(b1, null, highlighted);
        }

        double getHeightOfRow(StringBounder stringBounder) {
            double height = this.b1.calculateDimension(stringBounder).getHeight();
            if (this.b2 == null) {
                return height;
            }
            return Math.max(height, this.b2.calculateDimension(stringBounder).getHeight());
        }
    }
}

