/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.argon2;

import net.sourceforge.plantuml.argon2.model.Argon2Type;

public class Constants {
    public static final int ARGON2_BLOCK_SIZE = 1024;
    public static final int ARGON2_QWORDS_IN_BLOCK = 128;
    public static final int ARGON2_ADDRESSES_IN_BLOCK = 128;
    public static final int ARGON2_PREHASH_DIGEST_LENGTH = 64;
    public static final int ARGON2_PREHASH_SEED_LENGTH = 72;
    public static final int ARGON2_SYNC_POINTS = 4;
    public static final int ARGON2_DEFAULT_FLAGS = 0;
    public static final int ARGON2_VERSION_10 = 16;
    public static final int ARGON2_VERSION_13 = 19;

    public static class Messages {
        public static final String P_MIN_MSG = "degree of parallelism cannot be smaller than one";
        public static final String P_MAX_MSG = "parallelism cannot be greater than 16777216";
        public static final String M_MIN_MSG = "memory too small";
        public static final String T_MIN_MSG = "number of iterations cannot be less than one";
        public static final String T_MAX_MSG = "number of iterations too high";
        public static final String PWD_MIN_MSG = "password too short";
        public static final String PWD_MAX_MSG = "password too long";
        public static final String SALT_MIN_MSG = "salt too short";
        public static final String SALT_MAX_MSG = "salt too long";
        public static final String SECRET_MAX_MSG = "secret too long";
        public static final String ADDITIONAL_MAX_MSG = "additional data too long";
    }

    public static class Constraints {
        public static final int MAX_PASSWORD_LEN = 128;
        public static final int MIN_PARALLELISM = 1;
        public static final int MAX_PARALLELISM = 0x1000000;
        public static final int MIN_OUTLEN = 4;
        public static final int MAX_OUTLEN = Integer.MAX_VALUE;
        public static final int MIN_MEMORY = 8;
        public static final int MIN_ITERATIONS = 1;
        public static final int MAX_ITERATIONS = Integer.MAX_VALUE;
        public static final int MIN_PWD_LENGTH = 0;
        public static final int MAX_PWD_LENGTH = Integer.MAX_VALUE;
        public static final int MIN_SALT_LENGTH = 0;
        public static final int MAX_SALT_LENGTH = Integer.MAX_VALUE;
        public static final int MAX_SECRET_LENGTH = Integer.MAX_VALUE;
        public static final int MAX_AD_LENGTH = Integer.MAX_VALUE;
    }

    public static class Defaults {
        public static final int OUTLEN_DEF = 32;
        public static final int T_COST_DEF = 3;
        public static final int LOG_M_COST_DEF = 12;
        public static final int LANES_DEF = 1;
        public static final Argon2Type TYPE_DEF = Argon2Type.Argon2i;
        public static final int VERSION_DEF = 19;
        public static final int ARGON2_VERSION_NUMBER = 19;
        public static final boolean ENCODED_ONLY = false;
        public static final boolean RAW_ONLY = false;
    }
}

