/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public final class RtfStringConverter {
    private static final RtfStringConverter INSTANCE = new RtfStringConverter();
    private static final Map SPECIAL_CHARS;
    private static final Character DBLQUOTE;
    private static final Character QUOTE;
    private static final Character SPACE;

    private RtfStringConverter() {
    }

    public static RtfStringConverter getInstance() {
        return INSTANCE;
    }

    public void writeRtfString(Writer w, String str) throws IOException {
        if (str == null) {
            return;
        }
        w.write(this.escape(str));
    }

    public String escape(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(Math.max(16, str.length()));
        for (int i = 0; i < str.length(); ++i) {
            Character c = Character.valueOf(str.charAt(i));
            Character d = i != 0 ? Character.valueOf(str.charAt(i - 1)) : SPACE;
            String replacement = c.equals(DBLQUOTE) && d.equals(SPACE) ? "ldblquote" : (c.equals(QUOTE) && d.equals(SPACE) ? "lquote" : (String)SPECIAL_CHARS.get(c));
            if (replacement != null) {
                sb.append('\\');
                sb.append(replacement);
                sb.append(' ');
                continue;
            }
            if (c.charValue() > '\u007f') {
                sb.append("\\u");
                sb.append(Integer.toString(c.charValue()));
                sb.append("\\'3f");
                continue;
            }
            sb.append(c.charValue());
        }
        return sb.toString();
    }

    static {
        DBLQUOTE = Character.valueOf('\"');
        QUOTE = Character.valueOf('\'');
        SPACE = Character.valueOf(' ');
        SPECIAL_CHARS = new HashMap();
        SPECIAL_CHARS.put(Character.valueOf('\t'), "tab");
        SPECIAL_CHARS.put(Character.valueOf('\n'), "line");
        SPECIAL_CHARS.put(Character.valueOf('\''), "rquote");
        SPECIAL_CHARS.put(Character.valueOf('\"'), "rdblquote");
        SPECIAL_CHARS.put(Character.valueOf('\\'), "\\");
        SPECIAL_CHARS.put(Character.valueOf('{'), "{");
        SPECIAL_CHARS.put(Character.valueOf('}'), "}");
    }
}

