/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.graphic.FontChange;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;

class ColorAndSizeChange
implements FontChange {
    static final Pattern2 colorPattern = MyPattern.cmpile("(?i)color\\s*=\\s*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?");
    static final Pattern2 sizePattern = MyPattern.cmpile("(?i)size\\s*=\\s*[%g]?(\\d+)[%g]?");
    private final HtmlColor color;
    private final Integer size;

    ColorAndSizeChange(String s) {
        Matcher2 matcherColor = colorPattern.matcher(s);
        this.color = matcherColor.find() ? HtmlColorSet.getInstance().getColorIfValid(matcherColor.group(1)) : null;
        Matcher2 matcherSize = sizePattern.matcher(s);
        this.size = matcherSize.find() ? new Integer(matcherSize.group(1)) : null;
    }

    HtmlColor getColor() {
        return this.color;
    }

    Integer getSize() {
        return this.size;
    }

    @Override
    public FontConfiguration apply(FontConfiguration initial) {
        FontConfiguration result = initial;
        if (this.color != null) {
            result = result.changeColor(this.color);
        }
        if (this.size != null) {
            result = result.changeSize(this.size.intValue());
        }
        return result;
    }
}

