/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandActivate
extends SingleLineCommand2<SequenceDiagram> {
    public CommandActivate() {
        super(CommandActivate.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(activate|deactivate|destroy|create)"), new RegexLeaf("[%s]+"), new RegexLeaf("WHO", "([\\p{L}0-9_.@]+|[%g][^%g]+[%g])"), new RegexLeaf("[%s]*"), new RegexLeaf("BACK", "(#\\w+)?"), new RegexLeaf("LINE", "(?:[%s]+(#\\w+))?"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, RegexResult arg) {
        HtmlColor lineColor;
        HtmlColor backColor;
        LifeEventType type = LifeEventType.valueOf(StringUtils.goUpperCase(arg.get("TYPE", 0)));
        Participant p = diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("WHO", 0)));
        String error = diagram.activate(p, type, backColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("BACK", 0)), lineColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("LINE", 0)));
        if (error == null) {
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error(error);
    }
}

