/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.ComplementEmpty;
import net.sourceforge.plantuml.project.lang.Sentence;
import net.sourceforge.plantuml.project.lang.Something;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;

public abstract class SentenceSimple
implements Sentence {
    protected final Subject subjectii;
    private final IRegex verb;
    protected final Something complementii;

    public SentenceSimple(Subject subject, IRegex verb, Something complement) {
        this.subjectii = subject;
        this.verb = verb;
        this.complementii = complement;
    }

    public String getSignature() {
        return this.subjectii.getClass() + "/" + this.verb.getPattern() + "/" + this.complementii.getClass();
    }

    @Override
    public final IRegex toRegex() {
        if (this.complementii instanceof ComplementEmpty) {
            return new RegexConcat(RegexLeaf.start(), this.subjectii.toRegex(), RegexLeaf.spaceOneOrMore(), this.verb, RegexLeaf.end());
        }
        return new RegexConcat(RegexLeaf.start(), this.subjectii.toRegex(), RegexLeaf.spaceOneOrMore(), this.verb, RegexLeaf.spaceOneOrMore(), this.complementii.toRegex("0"), RegexLeaf.end());
    }

    @Override
    public final CommandExecutionResult execute(GanttDiagram project, RegexResult arg) {
        Failable<? extends Object> subject = this.subjectii.getMe(project, arg);
        if (subject.isFail()) {
            return CommandExecutionResult.error(subject.getError());
        }
        Failable<? extends Object> complement = this.complementii.getMe(project, arg, "0");
        if (complement.isFail()) {
            return CommandExecutionResult.error(complement.getError());
        }
        return this.execute(project, subject.get(), complement.get());
    }

    public abstract CommandExecutionResult execute(GanttDiagram var1, Object var2, Object var3);

    public IRegex getVerbRegex() {
        return this.verb;
    }
}

