/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.InlineArea;

public class InlineParent
extends InlineArea {
    private static final long serialVersionUID = -3047168298770354813L;
    protected List<InlineArea> inlines = new ArrayList<InlineArea>();
    protected transient boolean autoSize;
    protected int minChildOffset;
    private int maxAfterEdge;

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    @Override
    public void addChildArea(Area c) {
        assert (c instanceof InlineArea);
        if (this.inlines.size() == 0) {
            this.autoSize = this.getIPD() == 0;
        }
        InlineArea childArea = (InlineArea)c;
        this.inlines.add(childArea);
        childArea.setParentArea(this);
        if (this.autoSize) {
            this.increaseIPD(childArea.getAllocIPD());
        }
        this.updateLevel(childArea.getBidiLevel());
        int childOffset = childArea.getVirtualOffset();
        this.minChildOffset = Math.min(this.minChildOffset, childOffset);
        this.maxAfterEdge = Math.max(this.maxAfterEdge, childOffset + childArea.getVirtualBPD());
    }

    @Override
    int getVirtualOffset() {
        return this.getBlockProgressionOffset() + this.minChildOffset;
    }

    @Override
    int getVirtualBPD() {
        return this.maxAfterEdge - this.minChildOffset;
    }

    public List<InlineArea> getChildAreas() {
        return this.inlines;
    }

    @Override
    public boolean applyVariationFactor(double variationFactor, int lineStretch, int lineShrink) {
        boolean hasUnresolvedAreas = false;
        int cumulativeIPD = 0;
        for (InlineArea inline : this.inlines) {
            hasUnresolvedAreas |= inline.applyVariationFactor(variationFactor, lineStretch, lineShrink);
            cumulativeIPD += inline.getIPD();
        }
        this.setIPD(cumulativeIPD);
        return hasUnresolvedAreas;
    }

    @Override
    public List collectInlineRuns(List runs) {
        for (InlineArea ia : this.getChildAreas()) {
            runs = ia.collectInlineRuns(runs);
        }
        return runs;
    }

    public void resetChildrenLevel() {
        for (InlineArea inline : this.inlines) {
            inline.resetBidiLevel();
        }
    }

    private void updateLevel(int newLevel) {
        if (newLevel >= 0) {
            int curLevel = this.getBidiLevel();
            if (curLevel >= 0) {
                if (newLevel < curLevel) {
                    this.setBidiLevel(newLevel);
                }
            } else {
                this.setBidiLevel(newLevel);
            }
        }
    }
}

