/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.file;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FileWatcher {
    private final Map<File, Long> modified2 = new HashMap<File, Long>();

    public FileWatcher(Set<File> files) {
        if (files.size() == 0) {
            throw new IllegalArgumentException();
        }
        for (File f : files) {
            this.modified2.put(f, f.lastModified());
        }
    }

    public String toString() {
        return this.modified2.toString();
    }

    public boolean hasChanged() {
        for (Map.Entry<File, Long> ent : this.modified2.entrySet()) {
            long nowModified = ent.getKey().lastModified();
            if (ent.getValue() == nowModified) continue;
            return true;
        }
        return false;
    }
}

