/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;

public class FtileMargedRight
extends AbstractFtile {
    private final Ftile tile;
    private final double maxX;

    public FtileMargedRight(Ftile tile, double maxX) {
        super(tile.skinParam());
        this.tile = tile;
        this.maxX = maxX;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.tile.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return this.tile.getOutLinkRendering();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry orig = this.tile.calculateDimension(stringBounder);
        if (orig.getWidth() > this.maxX) {
            throw new IllegalStateException();
        }
        return new FtileGeometry(this.maxX, orig.getHeight(), orig.getLeft(), orig.getInY(), orig.getOutY());
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.draw(this.tile);
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.singleton(this.tile);
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.tile) {
            return UTranslate.none();
        }
        return super.getTranslateFor(child, stringBounder);
    }
}

