/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.skin.Skin;

public class SkinUtils {
    public static Skin loadSkin(String className) {
        ArrayList<String> errors = new ArrayList<String>();
        Skin result = SkinUtils.tryLoading(className, errors);
        if (result != null) {
            return result;
        }
        result = SkinUtils.tryLoading("net.sourceforge.plantuml.skin." + className, errors);
        if (result != null) {
            return result;
        }
        String packageName = StringUtils.goLowerCase(className);
        result = SkinUtils.tryLoading(packageName + "." + className, errors);
        if (result != null) {
            return result;
        }
        result = SkinUtils.tryLoading("net.sourceforge.plantuml.skin." + packageName + "." + className, errors);
        if (result != null) {
            return result;
        }
        for (String e : errors) {
            Log.println("err=" + e);
        }
        return null;
    }

    private static Skin tryLoading(String className, List<String> errors) {
        try {
            Class<?> cl = Class.forName(className);
            return (Skin)cl.newInstance();
        }
        catch (Exception e) {
            errors.add("Cannot load " + className);
            return null;
        }
    }
}

