/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.visio;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.golem.MinMaxDouble;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.ugraphic.visio.VisioLine;
import net.sourceforge.plantuml.ugraphic.visio.VisioRectangle;
import net.sourceforge.plantuml.ugraphic.visio.VisioShape;
import net.sourceforge.plantuml.ugraphic.visio.VisioText;

public class VisioGraphics {
    private final List<VisioShape> shapes = new ArrayList<VisioShape>();
    private final MinMaxDouble limits = new MinMaxDouble();

    public void createVsd(OutputStream os) throws IOException {
        double width = this.toInches(this.limits.getMaxX());
        double height = this.toInches(this.limits.getMaxY());
        this.out(os, "<?xml version='1.0' encoding='utf-8' ?>");
        this.out(os, "<VisioDocument xml:space='preserve' xmlns='http://schemas.microsoft.com/visio/2003/core' xmlns:vx='http://schemas.microsoft.com/visio/2006/extension' xmlns:v14='http://schemas.microsoft.com/office/visio/2010/extension'>");
        this.out(os, "<DocumentProperties>");
        this.out(os, "<Creator>PlantUML</Creator>");
        this.out(os, "</DocumentProperties>");
        this.out(os, "<DocumentSheet NameU='TheDoc' LineStyle='0' FillStyle='0' TextStyle='0'>");
        this.out(os, "</DocumentSheet>");
        this.out(os, "<Masters/>");
        this.out(os, "<Pages>");
        this.out(os, "<Page ID='0' NameU='Page-1' Name='Page 1' ViewScale='1' ViewCenterX='" + width / 2.0 + "' ViewCenterY='" + height / 2.0 + "'>");
        this.out(os, "<PageSheet LineStyle='0' FillStyle='0' TextStyle='0'>");
        this.out(os, "<PageProps>");
        this.out(os, "<PageWidth Unit='IN_F'>" + width + "</PageWidth>");
        this.out(os, "<PageHeight Unit='IN_F'>" + height + "</PageHeight>");
        this.out(os, "<PageScale Unit='IN_F'>1</PageScale>");
        this.out(os, "<DrawingScale Unit='IN_F'>2</DrawingScale>");
        this.out(os, "<DrawingSizeType>3</DrawingSizeType>");
        this.out(os, "<DrawingScaleType>0</DrawingScaleType>");
        this.out(os, "<InhibitSnap>0</InhibitSnap>");
        this.out(os, "</PageProps>");
        this.out(os, "</PageSheet>");
        this.out(os, "<Shapes>");
        for (VisioShape sh : this.shapes) {
            sh.yReverse(height).print(os);
        }
        this.out(os, "</Shapes>");
        this.out(os, "</Page>");
        this.out(os, "</Pages>");
        this.out(os, "</VisioDocument>");
    }

    private void out(OutputStream os, String s) throws IOException {
        os.write(s.getBytes());
        os.write("\n".getBytes());
    }

    private double toInches(double val) {
        return val / 72.0;
    }

    private void ensureVisible(double x, double y) {
        this.limits.manage(x, y);
    }

    public void rectangle(double x, double y, double width, double height) {
        this.ensureVisible(x, y);
        this.ensureVisible(x + width, y + height);
        VisioRectangle rect = VisioRectangle.createInches(this.shapes.size() + 1, x, y, width, height);
        this.shapes.add(rect);
    }

    public void text(String text, double x, double y, String family, int fontSize, double width, double height, Map<String, String> attributes) {
        this.ensureVisible(x, y);
        VisioText txt = VisioText.createInches(this.shapes.size() + 1, text, fontSize, x, y, width, height);
        this.shapes.add(txt);
    }

    public void line(double x1, double y1, double x2, double y2) {
        this.ensureVisible(x1, y1);
        if (x1 == x2 && y1 == y2) {
            return;
        }
        this.ensureVisible(x2, y2);
        VisioLine line = VisioLine.createInches(this.shapes.size() + 1, x1, y1, x2, y2);
        this.shapes.add(line);
    }

    private void line(Point2D p1, Point2D p2) {
        this.line(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void upath(double x, double y, UPath path) {
        double lx = x;
        double ly = y;
        for (USegment seg : path) {
            USegmentType type = seg.getSegmentType();
            double[] coord = seg.getCoord();
            if (type == USegmentType.SEG_MOVETO) {
                lx = coord[0] + x;
                ly = coord[1] + y;
                continue;
            }
            if (type == USegmentType.SEG_LINETO) {
                this.line(lx, ly, coord[0] + x, coord[1] + y);
                lx = coord[0] + x;
                ly = coord[1] + y;
                continue;
            }
            if (type == USegmentType.SEG_QUADTO) {
                this.line(lx, ly, coord[2] + x, coord[3] + y);
                lx = coord[2] + x;
                ly = coord[3] + y;
                continue;
            }
            if (type == USegmentType.SEG_CUBICTO) {
                this.line(lx, ly, coord[4] + x, coord[5] + y);
                lx = coord[4] + x;
                ly = coord[5] + y;
                continue;
            }
            if (type == USegmentType.SEG_CLOSE) continue;
            Log.println("unknown " + seg);
        }
    }

    public void polygon(UPolygon poly) {
        Point2D last = null;
        for (Point2D point2D : poly.getPoints()) {
            if (last != null) {
                this.line(last, point2D);
            }
            last = point2D;
        }
    }
}

