/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.utils;

import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.core.DiagramType;

public class StartUtils {
    public static final Pattern2 patternFilename = MyPattern.cmpile("^[@\\\\]start[^%s{}%g]+[%s{][%s%g]*([^%g]*?)[%s}%g]*$");
    public static final String PAUSE_PATTERN = "(?i)((?:\\W|\\<[^<>]*\\>)*)[@\\\\]unpause";
    public static final String START_PATTERN = "(?i)((?:[^\\w~]|\\<[^<>]*\\>)*)[@\\\\]start";
    private static final Pattern2 append = MyPattern.cmpile("^\\W*[@\\\\]append");

    public static String beforeStartUml(CharSequence2 result) {
        boolean inside = false;
        for (int i = 0; i < result.length(); ++i) {
            CharSequence2 tmp = result.subSequence(i, result.length());
            if (StartUtils.startsWithSymbolAnd("start", tmp)) {
                return result.subSequence(0, i).toString();
            }
            String single = result.subSequence(i, i + 1).toString();
            if (inside) {
                if (!single.equals(">")) continue;
                inside = false;
                continue;
            }
            if (single.equals("<")) {
                inside = true;
                continue;
            }
            if (!single.matches("[\\w~]")) continue;
            return null;
        }
        return null;
    }

    public static boolean isArobaseStartDiagram(CharSequence s) {
        String s2 = StringUtils.trinNoTrace(s);
        if (!s2.startsWith("@") && !s2.startsWith("\\")) {
            return false;
        }
        return DiagramType.getTypeFromArobaseStart(s2) != DiagramType.UNKNOWN;
    }

    public static boolean startsWithSymbolAnd(String value, CharSequence2 tmp) {
        return tmp.startsWith("@" + value) || tmp.startsWith("\\" + value);
    }

    public static boolean startsWithSymbolAnd(String value, String tmp) {
        return tmp.startsWith("@" + value) || tmp.startsWith("\\" + value);
    }

    public static boolean startOrEnd(CharSequence2 s) {
        String s2 = StringUtils.trinNoTrace(s);
        if (!s2.startsWith("@") && !s2.startsWith("\\")) {
            return false;
        }
        return StartUtils.startsWithSymbolAnd("end", s2) || DiagramType.getTypeFromArobaseStart(s2) != DiagramType.UNKNOWN;
    }

    public static boolean isArobaseEndDiagram(CharSequence s) {
        String s2 = StringUtils.trinNoTrace(s);
        return StartUtils.startsWithSymbolAnd("end", s2);
    }

    public static boolean isArobasePauseDiagram(CharSequence s) {
        String s2 = StringUtils.trinNoTrace(s);
        return StartUtils.startsWithSymbolAnd("pause", s2);
    }

    public static boolean isArobaseUnpauseDiagram(CharSequence s) {
        String s2 = StringUtils.trinNoTrace(s);
        return StartUtils.startsWithSymbolAnd("unpause", s2);
    }

    public static boolean isExit(CharSequence s) {
        String s2 = StringUtils.trinNoTrace(s);
        return s2.equals("!exit");
    }

    public static CharSequence2 getPossibleAppend(CharSequence2 s) {
        Matcher2 m = append.matcher(s);
        if (m.find()) {
            return s.subSequence(m.group(0).length(), s.length()).trin();
        }
        return null;
    }
}

