/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.area.Trait;

public class LinkResolver
implements Resolvable,
Serializable {
    private static final long serialVersionUID = -7102134165192960718L;
    private boolean resolved;
    private String idRef;
    private Area area;
    private transient List<Resolvable> dependents;

    public LinkResolver() {
        this(null, null);
    }

    public LinkResolver(String id, Area a) {
        this.idRef = id;
        this.area = a;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public String[] getIDRefs() {
        return new String[]{this.idRef};
    }

    @Override
    public void resolveIDRef(String id, List<PageViewport> pages) {
        this.resolveIDRef(id, pages.get(0));
    }

    public void resolveIDRef(String id, PageViewport pv) {
        if (this.idRef.equals(id) && pv != null) {
            this.resolved = true;
            if (this.area != null) {
                Trait.InternalLink iLink = new Trait.InternalLink(pv.getKey(), this.idRef);
                this.area.addTrait(Trait.INTERNAL_LINK, iLink);
                this.area = null;
            }
            this.resolveDependents(id, pv);
        }
    }

    public void addDependent(Resolvable dependent) {
        if (this.dependents == null) {
            this.dependents = new ArrayList<Resolvable>();
        }
        this.dependents.add(dependent);
    }

    private void resolveDependents(String id, PageViewport pv) {
        if (this.dependents != null) {
            ArrayList<PageViewport> pages = new ArrayList<PageViewport>();
            pages.add(pv);
            for (Resolvable r : this.dependents) {
                r.resolveIDRef(id, pages);
            }
        }
    }
}

