/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.MethodParameter;
import org.apache.bcel.classfile.Visitor;

public class MethodParameters
extends Attribute {
    private MethodParameter[] parameters = new MethodParameter[0];

    MethodParameters(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        super((byte)21, name_index, length, constant_pool);
        int parameters_count = input.readUnsignedByte();
        this.parameters = new MethodParameter[parameters_count];
        for (int i = 0; i < parameters_count; ++i) {
            this.parameters[i] = new MethodParameter(input);
        }
    }

    public MethodParameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(MethodParameter[] parameters) {
        this.parameters = parameters;
    }

    @Override
    public void accept(Visitor v) {
        v.visitMethodParameters(this);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        MethodParameters c = (MethodParameters)this.clone();
        c.parameters = new MethodParameter[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            c.parameters[i] = this.parameters[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeByte(this.parameters.length);
        for (MethodParameter parameter : this.parameters) {
            parameter.dump(file);
        }
    }
}

